package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.persistent.VisnDAO;

@Repository
@Transactional
public class VisnDAOImpl implements VisnDAO {
	public VisnDAOImpl() {
	}
	
	public VisnDAOImpl(SessionFactory factory) {
		sessionFactory = factory;
	}

	@Autowired
	private SessionFactory sessionFactory;

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Override
	public List<Visn> getVisns() {

		final String sql = "select * from Visn order by visn_id asc";
		return getSession()
				.createNativeQuery(sql, Visn.class)
				.getResultList();

	}

	@Override
	public Visn getVisn(String name) {

		final String sql = "select * from Visn where visn_name = :name";
		return getSession()
				.createNativeQuery(sql, Visn.class)
				.setParameter("name", name)
				.getSingleResult();

	}

	@Override
	public SimpleVisn getSimpleVisn(String name) {

		final String sql = "select * from Visn where visn_name = :name";
		return getSession()
				.createNativeQuery(sql, SimpleVisn.class)
				.setParameter("name", name)
				.getSingleResult();

	}	
	
	@Override
	public List<SimpleVisn> getSimpleVisns() {

		final String sql = "select * from VISN order by visn_id asc";
		return getSession()
				.createNativeQuery(sql, SimpleVisn.class) 
				.getResultList();
		
	}
	
	@Override
	public void insertVisn(Visn visn) {
		getSession().save(visn);
	}
	@Override
	public void deleteVisn(Visn visn) {
		getSession().delete(visn);
	}
	
	@Override
	public Visn getVisnById(Long id) {
		final String sql = "select * from VISN where visn_id =:id";
		return getSession()
				.createNativeQuery(sql, Visn.class)
				.setParameter("id", id)
				.getSingleResult();
	}

}
