package gov.va.med.ccht.persistent.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.transaction.Transactional;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

import gov.va.med.ccht.persistent.TerminologyDAO;
import gov.va.med.fw.model.lookup.AbstractActiveLookup;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;

/**
 * @author Muddaiah Ranga
 */
@Repository
@Transactional
public class TerminologyDAOImpl implements TerminologyDAO {

	private Map<String, String> findAllQueryMap = new HashMap<String, String>();
	
	private final Logger logger = Logger.getLogger(TerminologyDAOImpl.class);
	
	@Autowired
	private SessionFactory sessionFactory;
	
	public TerminologyDAOImpl() {
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.DayOfMonth", "daysOfMonth");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.DayOfQuarter", "daysOfQuarter");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.DayOfWeek", "weekDays");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.Month", "months");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.Quarter", "quarters");				
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.ReportPeriodType", "reportPeriodTypes");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.ReportRunFrequency", "reportRunFrequency");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.ReportScheduleType", "reportScheduleTypes");
		findAllQueryMap.put("gov.va.med.ccht.model.terminology.WeekOfMonth", "weeksOfmonth");
	}

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws DAOException {
		return findAll(terminologyType.getName());
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> findAll(String terminologyType) throws DAOException {

		// get custom query
		String query = null;
		
		String type = (String) findAllQueryMap.get(terminologyType);

		// create default query if custom query is not defined
		try {
			Class<?> clazz=null;
			if (type == null) {
				try {
					clazz = Class.forName(terminologyType);
					//test for trusted object types for IHTA Terminolgies
					if(!AbstractLookup.class.isAssignableFrom(clazz))
					{
						throw new DAOException("TerminologyType does not implement AbsractLookup");
					}
							
				} catch (ClassNotFoundException e) {
					logger.debug(e.getMessage());
					throw new DAOException("Terminology table not found");
				}
				String className = clazz.getName();
				if(className.equalsIgnoreCase("gov.va.med.ccht.model.terminology.RegistrationReason"))
				{					
					query = "select l from " + clazz.getName() + " l where l.inactiveFlag = 0 order by l.name asc";
				}
				else
				{
					query = "select l from " + clazz.getName() + " l order by l.code asc";
				}
				return getSession().createQuery(query).getResultList();
				
			} else {
					if("weeksOfmonth".equals(type))					
							query = "select l from gov.va.med.ccht.model.terminology.WeekOfMonth l order by l.identifier asc";
					else if ("reportRunFrequency".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.RunFrequency l order by l.code asc";
					else if ("months".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.Month l order by l.code asc";
					else if ("daysOfMonth".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfMonth l order by l.identifier asc";
					else if ("daysOfQuarter".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfQuarter l order by l.identifier asc";
					else if ("weekDays".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfWeek l order by l.code asc";
					else if ("reportScheduleTypes".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.ScheduleType l order by l.code asc";
					else if ("reportPeriodTypes".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.ReportPeriodType l order by l.code asc";
					else if("quarters".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.Quarter l order by l.code asc";
					
					return getSession().createQuery(query).getResultList();					
			}
		} catch (DataAccessException e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> findAllActive(Class<T> terminologyType) throws DAOException {
		
		if (AbstractActiveLookup.class.isAssignableFrom(terminologyType)) {
			return (List<T>) findAllActive(terminologyType.getName());
		} else {
			return findAll(terminologyType.getName());
		}
	}

	@SuppressWarnings("unchecked")
	public Lookup getByCode(String terminologyType, String code) throws DAOException {
		
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			logger.debug(e.getMessage(), e);
			throw new DAOException("Terminology table not found:" + terminologyType);
		}
		String query = "select l from " + clazz.getName() + " l where l.code = :code";
		List<Lookup> list = getSession().createQuery(query).setParameter("code", code).getResultList();
		
		if (list != null && list.size() > 0)
			return list.get(0);
		return null;
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> getByCodes(Class<T> terminologyType, Collection<String> codes) {
		
		String query = "select l from " + terminologyType.getName() + " l where l.code in (:codes)";
		List<T> list = getSession().createQuery(query).setParameter("codes", codes).getResultList();
		return list;
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws DAOException {
		return (T) this.getByCode(terminologyType.getName(), code);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getByName(java.lang.Class,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws DAOException {
		return (T) this.getByName(terminologyType.getName(), name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.persistent.TerminologyDAO#getByName(java.lang.String,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public Lookup getByName(String terminologyType, String name) throws DAOException {
		
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			logger.debug(e.getMessage());
			
			throw new DAOException("Terminology table not found:" + terminologyType);
		}
		String query = "select l from " + clazz.getName() + " l where l.name = :name";
		List<Lookup> list = getSession().createQuery(query).setParameter("name", name).getResultList();
		if (list != null && list.size() > 0)
			return list.get(0);
		return null;

	}

	/**
	 * @return the findAllQueryMap
	 */
	public Map<String, String> getFindAllQueryMap() {
		return findAllQueryMap;
	}

	/**
	 * @param findAllQueryMap
	 *            the findAllQueryMap to set
	 */
	public void setFindAllQueryMap(Map<String, String> findAllQueryMap) {
		this.findAllQueryMap = findAllQueryMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getById(java.lang.Class,
	 * java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getById(Class<T> terminologyType, Long id) throws DAOException {
		return (T) getById(terminologyType.getName(), id);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getById(java.lang.String,
	 * java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public Lookup getById(String terminologyType, Long id) throws DAOException {
		
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			
			throw new DAOException("Terminology table not found");
		}
		
		String query = "select l from " + clazz.getName() + " l where l.identifier = "
				+ id.toString();
		List<Lookup> list = getSession().createQuery(query).getResultList();
		if (list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.persistent.TerminologyDAO#searchIcd(java.lang.String,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public List<? extends Lookup> searchTerms(String terminologyType, String searchCriteria)
			throws DAOException {

		StringBuilder query = new StringBuilder();
		query.append("select l from " + terminologyType + " l where ");
		query.append("(l.code like '%" + searchCriteria + "%' or l.name like '%" + searchCriteria + "%') ");
		List<? extends Lookup> list = getSession().createQuery(query.toString()).getResultList();
		if (list != null && list.size() > 0) {
			return list;
		}
		return null;
	}

	private List<?> findAllActive(String terminologyType) throws DAOException {
		// get custom query
		String query = (String) findAllQueryMap.get(terminologyType);

		// create default query if custom query is not defined
		try {
			if (query == null) {
				query = "select l from " + terminologyType
						+ " l where l.inactive_flag = false order by l.name asc";
				return getSession().createQuery(query).getResultList();
			} else {
				return getSession().createNamedQuery(query).getResultList();
			}
		} catch (DataAccessException e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
	
	public void save(AbstractLookup lookup) throws DAOException {
		getSession().save(lookup);
	}
}
