package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.DeviceTrackerLog;
import gov.va.med.ccht.model.report.AggregateModality;
import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.ccht.ui.model.PSSReportForm;

@Repository
@Transactional
public class ReportsDAOImpl implements ReportsDAO {

	@Autowired
	private SessionFactory sessionFactory;
	
	public ReportsDAOImpl() {
	}

	public ReportsDAOImpl(SessionFactory factory) {
		sessionFactory = factory;
	}
		
	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Override
	public void setVendorComplianceReportCompletion(List<DeviceTrackerLog> deviceTrackerLogs) {
		deviceTrackerLogs.forEach(dtl -> {
			dtl.setProcessed(true);
			getSession().save(dtl);
		});

	}
	
	@Override
	public List<AggregateModality> getAggregateModalities() {
		String sql = "SELECT * FROM Modality_Aggregate_Type order by sort_order asc";
		return getSession().createNativeQuery(sql, AggregateModality.class).getResultList();
	}
	
	@Override
	public AggregateModality getAggregateModalityByCode(String code) {
		String sql = "SELECT * FROM Modality_Aggregate_Type WHERE code = :code";
		return getSession()
				.createNativeQuery(sql, AggregateModality.class)
				.setParameter("code", code)
				.getSingleResult();
	}

	/**
	 * Creates the "AND" statement in the where clause for the selected COC
	 */
	@Override
	public String getCategoryOfCare(PSSReportForm form) {
		StringBuilder sb = new StringBuilder();
		 if(form.getCategoriesOfCare() != null) {
				if(form.getCategoriesOfCare().length == 0 || 
						(form.getCategoriesOfCare()[0].equalsIgnoreCase("-1"))) {
					// Default to all COC
					String[] temp = {"1", "2", "3", "4", "5", "6", "7"};
					form.setCategoriesOfCare(temp);
				}
				else if (form.getCategoriesOfCare()[0].equalsIgnoreCase("-2")) {
					// All except L2
					String[] temp = {"1", "2", "3", "4", "6", "7"};
					form.setCategoriesOfCare(temp);
				}

				sb.append("AND f.level_of_care in (");
				sb.append(StringUtils.join(form.getCategoriesOfCare(), ", ") +") ");
			}
		 return sb.toString();
	}
}
