package gov.va.med.ccht.persistent.hibernate;

import java.util.Date;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.quartz.Trigger.TriggerState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.jobs.QuartzCronTrigger;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.persistent.QuartzDAO;

@Repository
@Transactional
public class QuartzDAOImpl implements QuartzDAO {

    @Autowired
    private SessionFactory sessionFactory;

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }
    
    @Override
    public String findCronExpression(String triggerName, String triggerGroup) {
        
        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT CRON_EXPRESSION FROM inf.QRTZ_CRON_TRIGGERS \n");
        sql.append("WHERE \n");
        sql.append("TRIGGER_NAME = :triggerName \n");
        sql.append("and \n");
        sql.append("TRIGGER_GROUP = :triggerGroup \n");
        
        return (String) sessionFactory
                .getCurrentSession()
                .createNativeQuery(sql.toString())
                .setParameter("triggerName", triggerName)
                .setParameter("triggerGroup", triggerGroup)
                .uniqueResult();

    }
    
    @Override
    public String findJobDescription(String jobName, String jobGroup) {

        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT DESCRIPTION FROM inf.QRTZ_JOB_DETAILS \n");
        sql.append("WHERE \n");
        sql.append("JOB_NAME = :jobName \n");
        sql.append("and \n");
        sql.append("JOB_GROUP = :jobGroup \n");

        return (String) sessionFactory
                .getCurrentSession()
                .createNativeQuery(sql.toString())
                .setParameter("jobName", jobName)
                .setParameter("jobGroup", jobGroup)
                .uniqueResult();

    }

    @Override
    public String findTriggerDescription(String triggerName, String triggerGroup) {
        
        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT DESCRIPTION FROM inf.QRTZ_TRIGGERS \n");
        sql.append("WHERE \n");
        sql.append("TRIGGER_NAME = :triggerName \n");
        sql.append("and \n");
        sql.append("TRIGGER_GROUP = :triggerGroup \n");

        return (String) sessionFactory
                .getCurrentSession()
                .createNativeQuery(sql.toString())
                .setParameter("triggerName", triggerName)
                .setParameter("triggerGroup", triggerGroup)
                .uniqueResult();

    }

    @Override
    public boolean isPaused(String triggerName, String triggerGroup) {

        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT TRIGGER_STATE FROM inf.QRTZ_TRIGGERS \n");
        sql.append("WHERE \n");
        sql.append("TRIGGER_NAME = :triggerName \n");
        sql.append("and \n");
        sql.append("TRIGGER_GROUP = :triggerGroup \n");

        final String state = (String) sessionFactory
                .getCurrentSession()
                .createNativeQuery(sql.toString())
                .setParameter("triggerName", triggerName)
                .setParameter("triggerGroup", triggerGroup)
                .uniqueResult();

        return state.equalsIgnoreCase(TriggerState.PAUSED.toString());

    }

    @Override
    public void updateTriggerStatus(String triggerName, String triggerGroup, String status) {

        String sql = "update inf.QRTZ_TRIGGERS set TRIGGER_STATE = :status where TRIGGER_NAME = :triggerName and TRIGGER_GROUP = :triggerGroup";
        sessionFactory.getCurrentSession().createNativeQuery(sql)
                .setParameter("status", status)
                .setParameter("triggerName", triggerName)
                .setParameter("triggerGroup", triggerGroup)
                .executeUpdate();
        
    }

    @Override
    public void updateAllTriggerStatus(String status) {
        
        String sql = "update inf.QRTZ_TRIGGERS set TRIGGER_STATE = :status";
        sessionFactory.getCurrentSession().createNativeQuery(sql)
                .setParameter("status", status)
                .executeUpdate();
        
    }

    @Override
    public void updateCronExpression(String triggerName, String triggerGroup, String cron) {

        final StringBuilder sql = new StringBuilder();
        sql.append("UPDATE inf.QRTZ_CRON_TRIGGERS SET CRON_EXPRESSION = :cron \n");
        sql.append("WHERE \n");
        sql.append("TRIGGER_NAME = :triggerName \n");
        sql.append("and \n");
        sql.append("TRIGGER_GROUP = :triggerGroup \n");
        
        sessionFactory.getCurrentSession().createNativeQuery(sql.toString())
        .setParameter("cron", cron)
        .setParameter("triggerName", triggerName)
        .setParameter("triggerGroup", triggerGroup)
        .executeUpdate();
        
    }

    @Override
    public void updateCronDescription(String triggerName, String triggerGroup, String cronDescription) {

        final StringBuilder sql = new StringBuilder();
        sql.append("UPDATE inf.QRTZ_TRIGGERS SET DESCRIPTION = :cronDescription \n");
        sql.append("WHERE \n");
        sql.append("TRIGGER_NAME = :triggerName \n");
        sql.append("and \n");
        sql.append("TRIGGER_GROUP = :triggerGroup \n");
        
        sessionFactory.getCurrentSession().createNativeQuery(sql.toString())
        .setParameter("cronDescription", cronDescription)
        .setParameter("triggerName", triggerName)
        .setParameter("triggerGroup", triggerGroup)
        .executeUpdate();
        
    }
}
