package gov.va.med.ccht.persistent.hibernate;

import java.io.Serializable;
import java.util.List;

import javax.transaction.Transactional;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.fw.model.batchprocess.JobConfig;
import gov.va.med.fw.model.batchprocess.JobResult;

@Repository
@Transactional
public class JobDAOImpl implements JobDAO, Serializable {
	
    private static final long serialVersionUID = -2209922670143059649L;

    @Autowired
	private SessionFactory sessionFactory;

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}

	@Override
	public void saveJobResult(JobResult jr) {
		getSession().saveOrUpdate(jr);
	}
	
	@Override
	public void saveJobConfig(JobConfig jc) {
		getSession().saveOrUpdate(jc);
	}

	@Override
	public JobResult findJobResult(long id) {

		final String sql = "SELECT * FROM ht.JOB_RESULT jr WHERE jr.job_result_id = :id";
		
		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql, JobResult.class)
				.setParameter("id", id)
				.uniqueResult();
		
	}

	@Override
	public List<JobResult> findJobResultsByStatus(String jobStatusCode) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * ");
		sql.append("FROM ht.JOB_RESULT jr ");
		sql.append("WHERE jr.job_status_code = :status ");
		sql.append("ORDER BY jr.RECORD_MODIFIED_DATE desc");

		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobResult.class)
				.setParameter("status", jobStatusCode)
				.getResultList();
	}

	@Override
	public List<JobResult> findFinishedJobResults(String jobName, String jobGroup) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * \n");
		sql.append("FROM ht.JOB_RESULT jr \n");
		sql.append("WHERE jr.job_name = :jobName \n");
		sql.append("AND jr.job_group_name = :jobGroup \n");
		sql.append("AND jr.job_status_code != 'IN_PROCESS' \n");
		sql.append("ORDER BY jr.RECORD_MODIFIED_DATE desc");

		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobResult.class)
				.setParameter("jobName", jobName)
				.setParameter("jobGroup", jobGroup)
				.getResultList();
		
	}

	@Override
	public List<JobResult> findJobResultsByName(String jobName) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * \n");
		sql.append("FROM ht.JOB_RESULT jr \n");
		sql.append("WHERE jr.job_name = :jobName \n");
		sql.append("ORDER BY jr.RECORD_MODIFIED_DATE desc");
		
		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobResult.class)
				.setParameter("jobName", jobName)
				.getResultList();

	}

	@Override
	public List<JobResult> findFinishedJobResults(String jobName) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * \n");
		sql.append("FROM ht.JOB_RESULT jr \n");
		sql.append("WHERE jr.job_name = :jobName \n");
		sql.append("AND jr.job_status_code != 'IN_PROCESS' \n");
		sql.append("ORDER BY jr.RECORD_MODIFIED_DATE desc");

		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobResult.class)
				.setParameter("jobName", jobName)
				.getResultList();
	}

	@Override
	public void deleteJobResult(JobResult jr) {
		getSession().delete(jr);
	}

	@Override
	public void deleteJobConfig(JobConfig jc) {
		getSession().delete(jc);
	}

	@Override
	public boolean existsJobResultWithName(String jobName) {
		
		final String sql = "select count(*) from ht.JOB_RESULT where job_name = :jobName ";
		
		return (Integer) sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql)
				.setParameter("jobName", jobName)
				.uniqueResult() > 0;

	}

	@Override
	public boolean existsJobConfigWithName(String jobName) {

		final String sql = "select count(*) from ht.job_config where job_name = :jobName ";
		
		return (Integer) sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql)
				.setParameter("jobName", jobName)
				.uniqueResult() > 0;

	}

	@Override
	public JobConfig findJobConfig(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<JobConfig> findJobConfigs(String jobName) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * \n");
		sql.append("FROM ht.JOB_CONFIG jc \n");
		sql.append("WHERE jc.job_name = :jobName \n");
		sql.append("ORDER BY jc.RECORD_MODIFIED_DATE desc");
		
		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobConfig.class)
				.setParameter("jobName", jobName)
				.getResultList();

	}

	@Override
	public List<JobConfig> findJobConfigs(String jobName, String jobGroup) {

		final StringBuilder sql = new StringBuilder();
		sql.append("SELECT * \n");
		sql.append("FROM ht.JOB_CONFIG jc \n");
		sql.append("WHERE jc.job_name = :jobName \n");
		sql.append("AND jc.job_group_name = :jobGroup \n");
		sql.append("ORDER BY jc.RECORD_MODIFIED_DATE desc");
		
		return sessionFactory
				.getCurrentSession()
				.createNativeQuery(sql.toString(), JobConfig.class)
				.setParameter("jobName", jobName)
				.setParameter("jobGroup", jobGroup)
				.getResultList();

	}

}
