package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.persistent.FacilityDAO;
import gov.va.med.fw.persistent.DAOException;

@Repository
@Transactional
public class FacilityDAOImpl implements FacilityDAO {
    
    public FacilityDAOImpl() {
    }
    
    public FacilityDAOImpl(SessionFactory factory) {
        sessionFactory = factory;
    }

    @Autowired
    private SessionFactory sessionFactory;

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }
    
    @Override
    public List<Facility> getFacilities() {
        final String sql = "select * from Facilities order by Facility_Name asc";
        return getSession().createNativeQuery(sql, Facility.class).getResultList();
    }
    
    @Override
    public List<Facility> getFacilitiesAscById() {
        final String sql = "select * from Facilities order by Facility_Id asc";
        return getSession().createNativeQuery(sql, Facility.class).getResultList();
    }
    
    @Override
    public List<Facility> getFacilities(String visnName) {
        
        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT f.[ID] \n");
        sql.append("    ,f.[Facility_Name] \n");
        sql.append("    ,f.[VISN_ID] \n");
        sql.append("    ,f.[Facility_ID] \n");
        sql.append("FROM \n");
        sql.append("    [Facilities] f \n");
        sql.append("    join [VISN] v on (f.[VISN_ID]=v.[VISN_ID]) \n");
        sql.append("WHERE \n");
        sql.append("    v.[VISN_Name] = :visnName \n");
        
        return getSession()
                .createNativeQuery(sql.toString(), Facility.class)
                .setParameter("visnName", visnName)
                .getResultList();
    }
    
    @Override
    public Facility getFacility(String stationNumber) throws DAOException {
         
        final String sql = "select * from Facilities where facility_id = :stationNumber";
        return getSession()
                .createNativeQuery(sql, Facility.class)
                .setParameter("stationNumber", stationNumber)
                .getSingleResult();

    }
    
    @Override
    public Facility getFacilityById(Long id) throws DAOException {
        final String sql = "select * from Facilities where id = :id";
        return getSession()
                .createNativeQuery(sql, Facility.class)
                .setParameter("id", id)
                .getSingleResult();
    }

    @Override
    public SimpleFacility getSimpleFacility(String stationNumber) {

        final String sql = "select * from Facilities where facility_id = :stationNumber";
        return getSession()
                .createNativeQuery(sql, SimpleFacility.class)
                .setParameter("stationNumber", stationNumber)
                .getSingleResult();

    }
    
    public List<SimpleFacility> getSortedSimpleFacilities() {

        final String sql = "SELECT ID, Facility_Name, VISN_ID, FACILITY_ID FROM Facilities Order By VISN_ID, FACILITY_ID, FACILITY_NAME asc";
        return getSession()
                .createNativeQuery(sql, SimpleFacility.class)
                .getResultList();

    }
    
    public List<SimpleFacility> getSimpleFacilities(SimpleVisn visn) 
    {

        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT f.[ID] \n");
        sql.append("    ,f.[Facility_Name] \n");
        sql.append("    ,f.[VISN_ID] \n");
        sql.append("    ,f.[Facility_ID] \n");
        sql.append("FROM \n");
        sql.append("    [Facilities] f \n");
        sql.append("WHERE \n");
        sql.append("    f.[VISN_ID] = :visnId \n");
        
        return getSession()
                .createNativeQuery(sql.toString(), SimpleFacility.class)
                .setParameter("visnId", visn.getId())
                .getResultList();
        
    }


    @Override
    public List<SimpleFacility> getSimpleFacilities() {

        final String sql = "select * from Facilities order by facility_name asc";
        return getSession() 
                .createNativeQuery(sql, SimpleFacility.class)
                .getResultList();

    }

    @Override
    public void insertFacility(Facility facility) {
        getSession().save(facility);
    }
    @Override
    public void deleteFacility(Facility facility) {
        getSession().delete(facility);
    }

}
