package gov.va.med.ccht.persistent.hibernate;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.ccht.model.report.DeviceModality;
import gov.va.med.ccht.persistent.DeviceModalityDAO;

@Repository
@Transactional
public class DeviceModalityDAOImpl implements DeviceModalityDAO {
	
	@Autowired
	private SessionFactory sessionFactory;
	
	public DeviceModalityDAOImpl(SessionFactory factory) {
		sessionFactory = factory;
	}

	private Session getSession() {
		return sessionFactory.getCurrentSession();
	}	

	@Override
	public DeviceModality getModalityByName(String name) {
		String sql = "SELECT * FROM device_modality_type WHERE name = " + name;
		return getSession().createNativeQuery(sql, DeviceModality.class).getSingleResult();
	}

	@Override
	public DeviceModality getModalityById(Long id) {
		String sql = "SELECT * FROM device_modality_type WHERE id = " + id; 
		return getSession().createNativeQuery(sql, DeviceModality.class).getSingleResult();
	}

	@Override
	public List<DeviceModality> getAllDeviceModalities() {
		String sql = "SELECT * FROM device_modality_type order by sort_order asc";
		return getSession().createNativeQuery(sql, DeviceModality.class).getResultList();
	}

}
