/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent.hibernate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

import gov.va.med.ccht.model.report.ReportParameters;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.service.report.StandardReportCriteria;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportNameResolver;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.date.TimeZoneUtils;

/**
 * Project: Common</br> Class: AbstractStandardReportDataDAOImpl</br> Created
 * on: Apr 12, 2010</br>
 * 
 * @author DNS
 * 
 */
public abstract class AbstractStandardReportDataDAOImpl  {
	
	/**
	 * A serialization key
	 */
	private static final long serialVersionUID = 1178123948624532738L;

	protected static final List<Long> EMPTY_LIST = Arrays.asList(0L);

	/**
	 * An instance of name resolver
	 */
	protected ReportNameResolver nameResolver = null;

	/**
	 * A default constructor
	 */
	protected AbstractStandardReportDataDAOImpl() {
		super();
	}

	/**
	 * @return Returns the nameResolver.
	 */
	public ReportNameResolver getNameResolver() {
		return this.nameResolver;
	}

	/**
	 * @param nameResolver
	 *            The nameResolver to set.
	 */
	public void setNameResolver(ReportNameResolver nameResolver) {
		this.nameResolver = nameResolver;
	}

	/**
	 * @see gov.va.med.fw.report.data.ReportDataDAO#preDataRetrieval(gov.va.med.fw.report.ReportConfiguration)
	 */
	public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {

		QueryCriteria reportCriteria = config.getQueryCriteria();

		if (reportCriteria instanceof StandardReportCriteria) {
			StandardReportCriteria criteria = (StandardReportCriteria) reportCriteria;
			ReportSetup setup = criteria.getReportSetup();
			ReportParameters reportParameters = setup.getReportParameters();
			TimeZone userTimeZone = null;

			// Set Report Parameters
			if (reportParameters != null) {
				userTimeZone = reportParameters.getUserTimeZone();
				Map<String, Object> map = reportParameters.getParameterMap();
				for (String key : map.keySet()) {
					criteria.addCriterion(key, map.get(key));
				}
			}
			// Set report generation time
			Date runDate = new Date();
			// criteria.setRunDate(runDate);
			criteria.addCriterion("runDateStr", TimeZoneUtils.convertDateToTimeZone(runDate,
					userTimeZone));

			// Set output file type
			if (setup.getFileType() != null) {
				criteria.setFileType(setup.getFileType().getCode());
			}
		}
	}

//	/**
//	 * @see gov.va.med.fw.report.data.hibernate.ConfigurableReportDataDAO#initDao()
//	 */
//	protected void initDao() throws Exception {
//		super.initDao();
//	}

	protected Map<String, Object> getQueryParameters(ReportSetup reportSetup) {
		return new HashMap<String, Object>();
	}

	/**
	 * Helper method when adding a single String value and the itemSpecified
	 * criteria is simply whether the String is not blank. See main addToMap
	 * method.
	 */
	protected void addStringToParamsIfNotBlank(Map<String, Object> paramMap, String allParamName,
			String specificParamName, String specificValue) {
		addValueObjectToParams(paramMap, allParamName, specificParamName, StringUtils
				.isNotBlank(specificValue), specificValue);
	}

	/**
	 * Adds two items to the paramMap.
	 * <p>
	 * If itemSpecified is true, the items added are <allParamName, "No"> (to
	 * signify that all available items should not be used) and
	 * <specificParamName, specificValues> which can be used in the query.
	 * <p>
	 * <p>
	 * If itemSpecified is false, the items added are 1) <allParamName,
	 * allParamName> (to signify that all available items should be used in the
	 * query; i.e. not filtered on this item) and 2) either <specificParamName,
	 * EMPTY_LIST> if the specificValue is any subclass of Collection, or
	 * <specificParamName, null> otherwise.
	 * 
	 * @param paramMap
	 *            The map to which we're adding the two items
	 * @param allParamName
	 *            The parameter name signifying all available items
	 * @param specificParamName
	 *            The parameter signifying a specific item
	 * @param itemSpecified
	 *            Whether to use the specific parameter value or allow all
	 *            values
	 * @param specificValue
	 *            The specific value we are filtering on; can be a collection or
	 *            a single value. It can be null in any case.
	 */
	protected void addValueObjectToParams(Map<String, Object> paramMap, String allParamName,
			String specificParamName, boolean itemSpecified, Object specificValues) {
		if (itemSpecified) {
			paramMap.put(allParamName, "No");
			paramMap.put(specificParamName, specificValues);
		} else {
			paramMap.put(allParamName, allParamName);
			paramMap.put(specificParamName, specificValues != null
					&& Collection.class.isAssignableFrom(specificValues.getClass()) ? EMPTY_LIST
					: null);
		}
	}
}