package gov.va.med.ccht.persistent;

import java.util.List;

import gov.va.med.fw.model.batchprocess.JobConfig;
import gov.va.med.fw.model.batchprocess.JobResult;

public interface JobDAO {
	
	public void saveJobResult(JobResult jr);
	public JobResult findJobResult(long id);
	public void deleteJobResult(JobResult jr);
	
	public void saveJobConfig(JobConfig jc);
	public JobConfig findJobConfig(long id);
	public List<JobConfig> findJobConfigs(String jobName);
	public List<JobConfig> findJobConfigs(String jobName, String jobGroup);
	public void deleteJobConfig(JobConfig jc);
	
	public List<JobResult> findJobResultsByName(String jobName);
	public List<JobResult> findJobResultsByStatus(String jobStatusCode);
	public List<JobResult> findFinishedJobResults(String jobName);
	public List<JobResult> findFinishedJobResults(String jobName, String jobGroup);
	
	public boolean existsJobResultWithName(String jobName);
	public boolean existsJobConfigWithName(String jobName);

}
