package gov.va.med.ccht.model.vendorsubmission;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.fw.util.DateUtils;

public class VendorSubmissionReportEntry  implements Serializable 
{

	private static final long serialVersionUID = 3706407676890703699L;

	private String vendorName;
	private Date dateOfLastSubmission;
	private int numDaysSinceLastSubmission;

	private String dateOfLastSubWithNumDays;
	
	private int numVrTwelveSurveys;
	private int numVersionOneSurveys;
	private int numVersionTwoSurveys;
	private int totalNumberOfSurveys;
	
	private String numVrTwelveSurveysAsString;
	private String numVersionOneSurveysAsString;
	private String numVersionTwoSurveysAsString;
	private String totalNumberOfSurveysAsString;

	
	private int surveyId;
	private String surveyName;

	public String getVendorName() {
		return vendorName;
	}
	public void setVendorName(String vendorName) {
		this.vendorName = vendorName;
	}
	public Date getDateOfLastSubmission() {
		return dateOfLastSubmission;
	}
	public void setDateOfLastSubmission(Date dateOfLastSubmission) {
		this.dateOfLastSubmission = dateOfLastSubmission;
	}
	public int getNumDaysSinceLastSubmission() {
		return numDaysSinceLastSubmission;
	}
	public void setNumDaysSinceLastSubmission(int numDaysSinceLastSubmission) {
		this.numDaysSinceLastSubmission = numDaysSinceLastSubmission;
	}
	public int getNumVrTwelveSurveys() {
		return numVrTwelveSurveys;
	}
	public void setNumVrTwelveSurveys(int numVrTwelveSurveys) {
		this.numVrTwelveSurveys = numVrTwelveSurveys;
	}
	public int getNumVersionOneSurveys() {
		return numVersionOneSurveys;
	}
	public void setNumVersionOneSurveys(int numVersionOneSurveys) {
		this.numVersionOneSurveys = numVersionOneSurveys;
	}
	public int getNumVersionTwoSurveys() {
		return numVersionTwoSurveys;
	}
	public void setNumVersionTwoSurveys(int numVersionTwoSurveys) {
		this.numVersionTwoSurveys = numVersionTwoSurveys;
	}
	public int getTotalNumberOfSurveys() {
		return numVrTwelveSurveys + numVersionOneSurveys + numVersionTwoSurveys;
	}
	public void setTotalNumberOfSurveys(int totalNumberOfSurveys) {
		this.totalNumberOfSurveys = totalNumberOfSurveys;
	}
	public int getSurveyId() {
		return surveyId;
	}
	public void setSurveyId(int surveyId) {
		this.surveyId = surveyId;
	}
	public String getSurveyName() {
		return surveyName;
	}
	public void setSurveyName(String surveyName) {
		this.surveyName = surveyName;
	}
	

	public String getDateOfLastSubWithNumDays() {
		
		SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYYHHMMSS);
		String theDate = format.format(dateOfLastSubmission);
		
		return theDate + " - " + numDaysSinceLastSubmission + " Days";
	}
	public void setDateOfLastSubWithNumDays(String dateOfLastSubWithNumDays) {
		this.dateOfLastSubWithNumDays = dateOfLastSubWithNumDays;
	}

	
	
	public String getNumVrTwelveSurveysAsString() 
	{		
		return Integer.toString(numVrTwelveSurveys);
	}
	
	public void setNumVrTwelveSurveysAsString(String numVrTwelveSurveysAsString) 
	{
		this.numVrTwelveSurveysAsString = numVrTwelveSurveysAsString;
	}
	
	public String getNumVersionOneSurveysAsString() 
	{		
		return Integer.toString(numVersionOneSurveys);
	}
	
	public void setNumVersionOneSurveysAsString(String numVersionOneSurveysAsString) 
	{
		this.numVersionOneSurveysAsString = numVersionOneSurveysAsString;	
	}
	
	public String getNumVersionTwoSurveysAsString() 
	{		
		return Integer.toString(numVersionTwoSurveys);
	}
	
	public void setNumVersionTwoSurveysAsString(String numVersionTwoSurveysAsString) 
	{
		this.numVersionTwoSurveysAsString = numVersionTwoSurveysAsString;
	}
	
	public String getTotalNumberOfSurveysAsString() {
		
		totalNumberOfSurveys = numVersionOneSurveys + numVersionTwoSurveys + numVrTwelveSurveys;
		
		return Integer.toString(totalNumberOfSurveys);
	}
	public void setTotalNumberOfSurveysAsString(String totalNumberOfSurveysAsString) {
		this.totalNumberOfSurveysAsString = totalNumberOfSurveysAsString;
	}
	
	
	@Override
	public String toString() 
	{
		return "******************************************\n" +
				"VendorSubmissionReportEntry \n" + 
				"[\nvendorName=" + vendorName +
				"\ndateOfLastSubmission = " + dateOfLastSubmission + 
				"\nnumDaysSinceLastSubmission = " + numDaysSinceLastSubmission +				 
				"\nsurveyId = " + surveyId + 
				"\nsurveyName = " + surveyName + 
				"\nnumVrTwelveSurveys = " + numVrTwelveSurveys +
				"\nnumVersionOneSurveys = " + numVersionOneSurveys + 
				"\nnumVersionTwoSurveys = " + numVersionTwoSurveys +				
				"\ntotalNumberOfSurveys = " + totalNumberOfSurveys +				 
				"]";
	}
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((vendorName == null) ? 0 : vendorName.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		VendorSubmissionReportEntry other = (VendorSubmissionReportEntry) obj;
		if (vendorName == null) {
			if (other.vendorName != null)
				return false;
		} else if (!vendorName.equals(other.vendorName))
			return false;
		return true;
	}
	/**
	 * Merge the survey numbers, date of survey and num days since last survey into
	 * one record
	 * @param recordToMerge
	 */
	public void mergeRecords(VendorSubmissionReportEntry recordToMerge)
	{
		mergeSurveyNumbers(recordToMerge);
		mergeSurveyDates(recordToMerge);
	}
	
	private void mergeSurveyNumbers(VendorSubmissionReportEntry recordToMerge)
	{
		
		switch(recordToMerge.getSurveyId())
		{
		case 1:
			setNumVrTwelveSurveys( recordToMerge.getNumVrTwelveSurveys() );
			break;
		case 2:
			setNumVersionOneSurveys( recordToMerge.getNumVersionOneSurveys() );
			break;
		case 3:
			setNumVersionTwoSurveys( recordToMerge.getNumVersionTwoSurveys() );
			break;
		}

	}
	
	private void mergeSurveyDates(VendorSubmissionReportEntry recordToMerge)
	{
		Date recordToMergeDate = recordToMerge.getDateOfLastSubmission();
		if(recordToMergeDate.after( dateOfLastSubmission ))
		{
			this.dateOfLastSubmission = recordToMergeDate;
			this.numDaysSinceLastSubmission = recordToMerge.getNumDaysSinceLastSubmission();
		}
	}
	
}
