package gov.va.med.ccht.model.terminology;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(schema = "ht", name = "HT_FEDERAL_HOLIDAYS")
public class FederalHoliday {
	
	private Long id;
	private Date inactiveDate = null;
	private Date activeDate = null;
	private Date date;
	private String description;
	
	@Id
	@Column(name = "ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}
	/**
	 * @return the date
	 */
	@Column(name = "HOLIDAY_DATE")
	public Date getDate() {
		return date;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the description
	 */
	@Column(name = "DESCRIPTION")
	public String getDescription() {
		return description;
	}
	/**
	 * @param inactiveDate the inactiveDate to set
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}
	/**
	 * @return the inactiveDate
	 */
	@Column(name = "INACTIVE_DATE")
	public Date getInactiveDate() {
		return inactiveDate;
	}
	/**
	 * @param activeDate the activeDate to set
	 */
	public void setActiveDate(Date activeDate) {
		this.activeDate = activeDate;
	}
	/**
	 * @return the activeDate
	 */
	@Column(name = "ACTIVE_DATE")
	public Date getActiveDate() {
		return activeDate;
	}
}
