/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2010
 *
 */
package gov.va.med.ccht.model.terminology;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class DayOfWeek extends AbstractLookup implements Comparable<DayOfWeek> {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7282677575555358062L;
	public static final Code MONDAY = new Code("1", "MON");
	public static final Code TUESDAY = new Code("2", "TUE");
	public static final Code WEDNESDAY = new Code("3", "WED");
	public static final Code THURSDAY = new Code("4", "THU");
	public static final Code FRIDAY = new Code("5", "FRI");
	public static final Code SATURDAY = new Code("6", "SAT");
	public static final Code SUNDAY = new Code("7", "SUN");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3946317980972383760L;

		private Code(String code, String alias) {
			super(code, alias);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	public int compareTo(DayOfWeek o) {
		return new Integer(getCode()).compareTo(new Integer(o.getCode()));
	}
}
