package gov.va.med.ccht.model.report;

import java.util.HashMap;
import java.util.Map;

public enum CompletedReportFieldType {
	REPORT_TYPE("reportType"),
	REPORT_ID("reportID"),
	REPORT_TITLE("reportTitle"),
	REPORT_FORMAT("reportFormat"),
	REPORT_FILE_TYPE("reportFileType"),
	REPORT_SUBMITTED_BY("reportSubmittedBy");

	private static final Map<String, CompletedReportFieldType> CODE_MAP = new HashMap<String, CompletedReportFieldType>();

	static {
		for (CompletedReportFieldType type : values())
			CODE_MAP.put(type.getCode(), type);
	}

	private String code;

	private CompletedReportFieldType(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public String getNamedQuery() {
		return "completedReportUniqueFilterValues_" + getCode();
	}

	public static CompletedReportFieldType getRequiredWithCode(String code) {
		CompletedReportFieldType val = CODE_MAP.get(code);
		if (val == null)
			throw new IllegalArgumentException("No "
					+ CompletedReportFieldType.class.getSimpleName() + " exists with the code "
					+ code);
		return val;
	}
}
