package gov.va.med.ccht.model.report;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

/**
 * This object is not the same as the other Modality term.
 * It is for the aggregate modalities and ties modality names to column names.
 * 
 */
@Entity
@Table(schema="dbo", name="Modality_Aggregate_Type")
public class AggregateModality {

	private Long id;
	private String code;
	// limited to upper case, lower case and numbers
	private String name;
	// limited to upper case, lower case, numbers, comma, and open/close parenthesis.
	private String description;
	// Audit fields but missing RECORD_MODIFIED_COUNT
	private String recordCreatedBy;
	
	private Date recordCreatedDate;
	private String recordModifiedBy;
	private Date recordModifiedDate;

	@Id
	@Column(name = "ID")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Column(name = "CODE")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = ESAPIValidator.validateStringInput(name, ESAPIValidationType.UpperAndLowerCase_WhiteList);
	}

	@Column(name = "DESCRIPTION")
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = ESAPIValidator.validateStringInput(description, ESAPIValidationType.ModalityDescription_WhiteList);
	}
	
	// Defining the Audit fields because the hibernate mapping for CCHTAuditFields includes
	// RECORD_MODIFIED_COUNT 
	@Column(name = "RECORD_CREATED_BY", length = 30, nullable = false)
	public String getRecordCreatedBy() {
		return recordCreatedBy;
	}

	public void setRecordCreatedBy(String recordCreatedBy) {
		if (StringUtils.isEmpty(recordCreatedBy)) {
			this.recordCreatedBy = "";
		} else {
			this.recordCreatedBy = recordCreatedBy;
		}
	}

	@Column(name = "RECORD_CREATED_DATE", nullable = false)
	public Date getRecordCreatedDate() {
		return recordCreatedDate;
	}

	public void setRecordCreatedDate(Date recordCreatedDate) {
		this.recordCreatedDate = recordCreatedDate;
	}

	@Column(name = "RECORD_MODIFIED_BY", length = 30, nullable = false)
	public String getRecordModifiedBy() {
		return recordModifiedBy;
	}

	public void setRecordModifiedBy(String recordModifiedBy) {
		this.recordModifiedBy = recordModifiedBy;
	}

	@Column(name = "RECORD_MODIFIED_DATE", nullable = false)
	public Date getRecordModifiedDate() {
		return recordModifiedDate;
	}

	public void setRecordModifiedDate(Date recordModifiedDate) {
		this.recordModifiedDate = recordModifiedDate;
	}
}
