package gov.va.med.ccht.model.qir;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.Formula;

import gov.va.med.ccht.model.CCHTAuditFields;

@Entity
@Table(schema = "qir", name = "QIR_VENDOR_ACTIONS")
public class QIRVendorAction extends CCHTAuditFields implements Comparable<QIRVendorAction> {
	
	private Long id;
	private QIR qir = null;
	private Date date = null;
	private String action = null;
	private String submittedByName = null;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "QIR_VENDOR_ACTION_ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}
	
	public void setId(Long id){
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name = "QIR_ID")
	public QIR getQir() {
		return qir;
	}

	public void setQir(QIR qir) {
		this.qir = qir;
	}

	@Column(name="ACTION_DATE")
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	@Column(name="ACTION_TEXT")
	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	// Commented out for now as @Formula can throw a NullPointerException due to a documented bug in Hibernate.
	// Possible work-around is to use SqlResultSetMapping
	//@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")
	@Transient
	public String getSubmittedByName() {
		return submittedByName;
	}

	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}

	@Override
	public int compareTo(QIRVendorAction o) {
		if (o != null) {
			QIRVendorAction other = (QIRVendorAction) o;
			Date otherDate = other.getDate();
			if (otherDate == null || date == null)
				return 0; // no date not an expected scenario
			return date.compareTo(otherDate);
		}
		return 0;
	}
}
