/**
 * 
 */
package gov.va.med.ccht.model.qir;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.AbstractLookup;

@Entity
@Table(schema="qir", name="QIR_STATUS_TYPES")
public class QIRStatusType extends AbstractLookup {

	private static final long serialVersionUID = -6544766354601437705L;
	
	public static final String NEW = "1";
	public static final String APPROVED = "2";
	public static final String WITHDRAWN = "3";
	public static final String REPLIED = "4";
	public static final String AGREED = "5";
	public static final String CLOSED = "6";
	
	private Long id;
	private String name;
	
	@Id
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name = "ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Column(name = "NAME", length = 100)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Transient
	public boolean isNew() {
		return getCode().equals(NEW);
	}

	@Transient
	public boolean isApproved() {
		return getCode().equals(APPROVED);
	}

	@Transient
	public boolean isWithdrawn() {
		return getCode().equals(WITHDRAWN);
	}

	@Transient
	public boolean isReplied() {
		return getCode().equals(REPLIED);
	}

	@Transient
	public boolean isAgreed() {
		return getCode().equals(AGREED);
	}

	@Transient
	public boolean isClosed() {
		return getCode().equals(CLOSED);
	}
}