package gov.va.med.ccht.model.qir;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.ccht.model.Attachment;

@Entity
@Table(schema="qir", name="QIR_DOC_ATTACHMENTS")
public class QIRSimpleAttachment extends Attachment {

	private Long id;

	private Integer length;

	private QIR qir = null;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "QIR_DOC_ATTCHMNT_ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@ManyToOne
	@JoinColumn(name = "QIR_ID")
	public QIR getQir() {
		return qir;
	}

	public void setQir(QIR qir) {
		this.qir = qir;
	}

	@Column(name="DOCUMENT_SIZE")
	public Integer getLength() {
		return this.length;
	}

	public void setLength(Integer length) {
		this.length = length;
	}
}