/**
 * 
 */
package gov.va.med.ccht.model.qir;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;

import gov.va.med.fw.ui.model.TermType;

/**
 * @author DNS
 *
 */
public class QIRSearchParameters implements Serializable {

	private static final long serialVersionUID = -8185750419457432313L;

	private String id;
	@Valid
	private TermType qirType;
	@Valid
	private List<String> qirStatuses;
	@Valid
	private TermType visn;
	@Valid
	private TermType facility;
	@Valid
	private TermType deviceType;
	@Valid
	private TermType vendor;
	private String submittedBy;
	private Date submittedFromDate;
	private Date submittedToDate;
	private Integer maxRecords;
	private Boolean isVendor;

	// Members for populating dropdowns
	private Map<String, TermType> facilities;
	private String selectedFacilityId;

	private Map<String, TermType> vendors;
	private String selectedVendorId;

	private Map<String, TermType> typesOfComplaint;
	private String selectedComplaintTypeId;

	private Map<String, TermType> statusTypes;
	private String selectedStatusTypeId;

	private String fromDateAsString;
	private String toDateAsString;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public TermType getQirType() {
		return qirType;
	}

	public void setQirType(TermType qirType) {
		this.qirType = qirType;
	}

	public List<String> getQirStatuses() {
		return qirStatuses;
	}

	public void setQirStatuses(List<String> qirStatuses) {
		this.qirStatuses = qirStatuses;
	}

	public TermType getVisn() {
		return visn;
	}

	public void setVisn(TermType visn) {
		this.visn = visn;
	}

	public TermType getFacility() {
		return facility;
	}

	public void setFacility(TermType facility) {
		this.facility = facility;
	}

	public TermType getDeviceType() {
		return deviceType;
	}

	public void setDeviceType(TermType deviceType) {
		this.deviceType = deviceType;
	}

	public TermType getVendor() {
		return vendor;
	}

	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}

	public String getSubmittedBy() {
		return submittedBy;
	}

	public void setSubmittedBy(String submittedBy) {
		this.submittedBy = submittedBy;
	}

	public Date getSubmittedFromDate() {
		return submittedFromDate;
	}

	public void setSubmittedFromDate(Date submittedFromDate) {
		this.submittedFromDate = submittedFromDate;
	}

	public Date getSubmittedToDate() {
		return submittedToDate;
	}

	public void setSubmittedToDate(Date submittedToDate) {
		this.submittedToDate = submittedToDate;
	}

	public Integer getMaxRecords() {
		return maxRecords;
	}

	public void setMaxRecords(Integer maxRecords) {
		this.maxRecords = maxRecords;
	}

	public Boolean getIsVendor() {
		return isVendor;
	}

	public void setIsVendor(Boolean isVendor) {
		this.isVendor = isVendor;
	}

	public Map<String, TermType> getFacilities() {
		return facilities;
	}

	public void setFacilities(Map<String, TermType> facilities) {
		this.facilities = facilities;
	}

	public String getSelectedFacilityId() {
		return selectedFacilityId;
	}

	public void setSelectedFacilityId(String selectedFacilityId) {
		this.selectedFacilityId = selectedFacilityId;
	}

	public Map<String, TermType> getVendors() {
		return vendors;
	}

	public void setVendors(Map<String, TermType> vendors) {
		this.vendors = vendors;
	}

	public String getSelectedVendorId() {
		return selectedVendorId;
	}

	public void setSelectedVendorId(String selectedVendorId) {
		this.selectedVendorId = selectedVendorId;
	}

	public Map<String, TermType> getTypesOfComplaint() {
		return typesOfComplaint;
	}

	public void setTypesOfComplaint(Map<String, TermType> typesOfComplaint) {
		this.typesOfComplaint = typesOfComplaint;
	}

	public String getSelectedComplaintTypeId() {
		return selectedComplaintTypeId;
	}

	public void setSelectedComplaintTypeId(String selectedComplaintTypeId) {
		this.selectedComplaintTypeId = selectedComplaintTypeId;
	}

	public String getSelectedStatusTypeId() {
		return selectedStatusTypeId;
	}

	public void setSelectedStatusTypeId(String selectedStatusTypeId) {
		this.selectedStatusTypeId = selectedStatusTypeId;
	}

	public String getFromDateAsString() {
		return fromDateAsString;
	}

	public void setFromDateAsString(String fromDateAsString) {
		this.fromDateAsString = fromDateAsString;
	}

	public String getToDateAsString() {
		return toDateAsString;
	}

	public void setToDateAsString(String toDateAsString) {
		this.toDateAsString = toDateAsString;
	}

}
