/**
 * 
 */
package gov.va.med.ccht.model.qir;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import gov.va.med.ccht.model.Attachment;
import gov.va.med.ccht.model.terminology.DocumentType;

/**
 * @author DNS
 *
 */
@Entity
@Table(schema="qir", name="QIR_DOC_ATTACHMENTS")
public class QIRAttachment extends Attachment {

	private Long id;
	private Long qirId;
	private byte[] data;
	private Integer length;

	public QIRAttachment() {
	}

	public QIRAttachment(Long qirId, byte[] data, Integer length, Date date, DocumentType documentType,
			String documentName) {
		super(date, documentType, documentName);

		this.qirId = qirId;
		this.data = data;
		this.length = length;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "QIR_DOC_ATTCHMNT_ID", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
	
	@Column(name = "QIR_ID")
	public Long getQirId() {
		return qirId;
	}

	public void setQirId(Long qirId) {
		this.qirId = qirId;
	}

	@Column(name = "DOCUMENT_DATA")
	public byte[] getData() {
		return data;
	}

	public void setData(byte[] data) {
		this.data = data;
	}

	@Column(name = "DOCUMENT_SIZE")
	public Integer getLength() {
		return this.length;
	}

	public void setLength(Integer length) {
		this.length = length;
	}
}
