package gov.va.med.ccht.model.pssreport;

import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

public class VendorSubmissionReportData {
	
	// limited to upper case, lower case, and numbers
	private String vendorName;
	
	private String surveyVersionOneTotal;
	private String surveyVersionTwoTotal;
	private String totalNumberOfSurveys;
	
	// limited to upercase, lower case,  numbers, forward slash, dash, open/close paren
	private String dateLastSurveyWithDays;
	
	public VendorSubmissionReportData() {
		super();
		// not all values will get set, but zero still needs to be displayed.
		this.surveyVersionOneTotal = "0";
		this.surveyVersionTwoTotal = "0";
		this.totalNumberOfSurveys = "0";
		this.totalNumberOfSurveys = "0";
	}
	
	public String getVendorName() {
		return vendorName;
	}
	public void setVendorName(String vendorName) {
		this.vendorName = ESAPIValidator.validateStringInput(vendorName, ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);
	}
	public String getSurveyVersionOneTotal() {
		return surveyVersionOneTotal;
	}
	public void setSurveyVersionOneTotal(String surveyVersionOneTotal) {
		this.surveyVersionOneTotal = surveyVersionOneTotal;
	}
	public String getSurveyVersionTwoTotal() {
		return surveyVersionTwoTotal;
	}
	public void setSurveyVersionTwoTotal(String survVeyersionTwoTotal) {
		this.surveyVersionTwoTotal = survVeyersionTwoTotal;
	}
	public String getTotalNumberOfSurveys() {
		return totalNumberOfSurveys;
	}
	public void setTotalNumberOfSurveys(String totalNumberOfSurveys) {
		this.totalNumberOfSurveys = totalNumberOfSurveys;
	}
	public String getDateLastSurveyWithDays() {
		return dateLastSurveyWithDays;
	}
	public void setDateLastSurveyWithDays(String dateLastSurveyWithDays) {
		this.dateLastSurveyWithDays = ESAPIValidator.validateStringInput(dateLastSurveyWithDays, ESAPIValidationType.StandardDateWithDays_WhiteList);
	}
	
}
