package gov.va.med.ccht.model.pssreport;

import java.util.ArrayList;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.ccht.service.common.facility.FacilityService;
import gov.va.med.ccht.ui.model.PSSReportForm;

/**
 * 
 * @author DNS
 *
 */
public class DistributionOfSurveysReport {

	ArrayList<String[]> report;
	
	private static final int BREAKOUT_COL = 0;
	private static final int VENDOR_NAME = 1;
	private static final int NUM_OF_SURVEYS = 2;
	
	private static final int NATIONAL = 1;
	private static final int VISN = 2;
	private static final int FACILITY = 3;
	
	private static final int IVR_ROW = 3;
	private static final int BROWSER_ROW = 4;
	private static final int HOME_DEVICE_ROW = 5;
	
	public DistributionOfSurveysReport() {
		super();
		this.report = new ArrayList<String[]>();
	}

	public void addRow(Object[] reportRow, int typeOfReport, PSSReportForm form) {
		
		String row[] = new String[3];
			
		switch(typeOfReport){
		
		case NATIONAL:
			break;
		case VISN:
			row[0] = "VISN " + String.valueOf(reportRow[BREAKOUT_COL]);
			break;
		case FACILITY:
				row[0] = "Facility " + String.valueOf(reportRow[BREAKOUT_COL]);
			break;
			
		}
		
		row[1] = (String)reportRow[VENDOR_NAME];
		row[2] = Integer.toString((int)reportRow[NUM_OF_SURVEYS]);
		
		report.add(row);
	}

	public ArrayList<String[]> getReport() {
		return report;
	}

	public void setReport(ArrayList<String[]> report) {
		this.report = report;
	}
	
	public void createTotalsRow(int rowSize) {
		
		int totalSurveys = 0;
		int totalIvr = 0;
		int totalBrowser = 0;
		int totalHomeDevice = 0;
		
		if(!report.isEmpty()) { // do not create totals row if empty
			for(String[] reportRow : report) {
				
				totalSurveys += Integer.parseInt(reportRow[NUM_OF_SURVEYS]);
				if(rowSize >= 6) {
					totalIvr += Integer.parseInt(reportRow[IVR_ROW]);
					totalBrowser += Integer.parseInt(reportRow[BROWSER_ROW]);
					totalHomeDevice += Integer.parseInt(reportRow[HOME_DEVICE_ROW]);
				}
				
			}
			
			if(rowSize >= 6) {
				String[] totalsRow = {"", "Total Surveys", String.valueOf(totalSurveys),
						String.valueOf(totalIvr), String.valueOf(totalBrowser), String.valueOf(totalHomeDevice)};
				report.add(totalsRow);
			}
			else {
				String[] totalsRow = {"", "Total Surveys", String.valueOf(totalSurveys)};
				report.add(totalsRow);
			}
		}
	}
}
