package gov.va.med.ccht.model.common;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.Lookup;

@Entity
@Table(schema="dbo", name="VISN")
public class Visn implements Lookup { 

	private Integer id;
	private String name;

	private Set<Facility> facilities;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name="VISN_ID", unique=true, nullable=false)
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}	

	@Column(name = "VISN_Name",  length = 10, nullable = false, columnDefinition = "char")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@OneToMany
    @JoinColumn(name="VISN_ID")
	public Set<Facility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Set<Facility> facilities) {
		this.facilities = facilities;
	}

	@Override
	@Transient
	public String getCode() {
		return name;
	}

	@Override
	@Transient
	public String getDescription() {
		return name;
	}
	
	@Override
	public String toString() {
		return name;
	}
}
