package gov.va.med.ccht.model.common;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;

@Entity
@Table(schema = "dbo", name = "Vendor")
public class Vendor implements Lookup, Comparable<Vendor> {

	private Integer id;
	// limited to upper case, lower case, and numbers
	private String name;
	
	private String number;
	private String email_to;
	private String email_cc;
	private Date dateActive;
	private Date dateInactive;
	private String officialName;

	@Id
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name="VENDOR_ID", unique=true, nullable=false)
	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	@Column(name="VENDOR_NAME", length=100, nullable=false)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = ESAPIValidator.validateStringInput(name, ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);
	}

	@Column(name = "VENDOR_NUMBER", length=10, nullable=true)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@Column(name = "OFFICIAL_NAME", length=100, nullable=true)
	public String getOfficialName() {
		return officialName;
	}

	public void setOfficialName(String officialName) {
		this.officialName = officialName;
	}

	@Column(name = "VENDOR_EMAIL_TO", length=8000, nullable=true)
	public String getEmail_to() {
		return email_to;
	}

	public void setEmail_to(String email_to) {
		this.email_to = email_to;
	}

	@Column(name = "VENDOR_EMAIL_CC", length=8000, nullable=true)
	public String getEmail_cc() {
		return email_cc;
	}

	public void setEmail_cc(String email_cc) {
		this.email_cc = email_cc;
	}

	@Override
	public int compareTo(Vendor o) {
		if (o == null)
			return 0;
		int c = getName().compareTo(o.getName());
		return c;
	}

	@Override
	@Transient
	public String getCode() {
		return String.valueOf(id);
	}

	@Override
	@Transient
	public String getDescription() {
		return name;
	}

	@Column(name = "DATE_ACTIVE", nullable=true)
	public Date getDateActive() {
		return dateActive;
	}

	public void setDateActive(Date dateActive) {
		this.dateActive = dateActive;
	}

	@Column(name = "DATE_INACTIVE", nullable=true)
	public Date getDateInactive() {
		return dateInactive;
	}

	public void setDateInactive(Date dateInactive) {
		this.dateInactive = dateInactive;
	}

	public String toString() {
		return name;
	}
}
