package gov.va.med.ccht.model.common;

import java.util.Comparator;

/**
 * This class is solely used to sort Facilities during registration.
 */
public class FacilityRegComparator implements Comparator<SimpleFacility> {

	@Override
	public int compare(SimpleFacility fac1, SimpleFacility fac2) {
		// Sort by VISN name then facility
		int visnCompare = fac1.getVisn().getId().compareTo(fac2.getVisn().getId());
		if(visnCompare != 0) {
			return visnCompare;
		}
		else {
			return fac1.getStationNumber().compareTo(fac2.getStationNumber());
		}
	}
}
