/**
 * 
 */
package gov.va.med.ccht.model.common;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

/**
 * @author DNS
 *
 */
@Entity
@Table(schema="dbo", name="Facilities")
public class Facility implements Lookup, Comparable<Facility> {

	private static final long serialVersionUID = 3691312169279695841L;

	public static final Facility ALL_FACILITIES = new Facility("All Facilities");
	
	private String name;
	private Visn visn;
	private String stationNumber;	
	private int id;
	
	public Facility() {
		super();
	}
	
	private Facility(String name) {
		super();
		this.name = name;
	}
	
	@Id
	@GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
	@Column(name = "ID", unique = true, nullable = false)
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@Column(name = "Facility_Name", length = 50)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Transient
	public String getCode() {
		return stationNumber;
	}
	
	@ManyToOne
    @JoinColumn(name="VISN_ID")
	public Visn getVisn() {
		return visn;
	}

	public void setVisn(Visn visn) {
		this.visn = visn;
	}

	@Column(name = "Facility_ID", length = 50)
	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	@Transient
	public String getDescription() {
		// TODO: IMPLEMENT
		String desc = visn == null ? "" : visn.getName().trim();
		if (StringUtils.isNotEmpty(stationNumber)) {
			desc = desc + " Facility " + stationNumber;
		}
		desc = desc + " " + name;
		return desc.trim();
	}

	@Transient
	private Integer getVisnId() {
		return visn == null ? 0 : visn.getId();
	}

	public int compareTo(Facility o) {
		
		if (o == null)
			return 0;
		/* Relies on the fact that the IDs in the DB for each VISN align with the VISN number - CPB */
		
		int c = getVisnId().compareTo(o.getVisnId());
		if (c == 0) {
			return (stationNumber + name).compareTo(o.stationNumber + o.name);
		} else {
			return c;
		}
	}

	public String toString() {
		return getDescription();
	}

}
