package gov.va.med.ccht.model.car;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import gov.va.med.fw.ui.model.TermType;

public class CensusActivityReportParameters implements Serializable 
{	
	private static final long serialVersionUID = -7242591894427956373L;
	
	private static final Map<String, String> columnMap;

	public static final int NATIONAL = 0;
	public static final int VISN = 1;
	public final static int FACILITY = 2;
	
	private int reportType;
	private Date weekEndingDate;
	private String reportDate;
	private TermType modality;
	private TermType vendor;
	private TermType visn;
	private boolean showVendorSubTotals;
	
	static {
		columnMap = new HashMap<String, String>();
		columnMap.put("Peripheral", "Measurement");
		columnMap.put("notyetassigned", "MessagingUnknown");
		columnMap.put("Cellular", "CellModem");
		columnMap.put("Satellite", "Satellite");
		columnMap.put("Digital", "DigImageCapture");
		columnMap.put("MessagingTotal", "Dialogue");
		columnMap.put("Browser", "Browser");
	}
	
	public int getReportType() {
		return reportType;
	}
	public void setReportType(int reportType) {
		this.reportType = reportType;
	}
	public Date getWeekEndingDate() {
		return weekEndingDate;
	}
	public void setWeekEndingDate(Date weekEndingDate) {
		this.weekEndingDate = weekEndingDate;
	}
	public TermType getModality() {
		return modality;
	}
	public void setModality(TermType modality) {
		this.modality = modality;
	}
	public TermType getVendor() {
		return vendor;
	}
	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}
	public TermType getVisn() {
		return visn;
	}
	public void setVisn(TermType visn) {
		this.visn = visn;
	}
	public boolean isShowVendorSubTotals() {
		return showVendorSubTotals;
	}
	public void setShowVendorSubTotals(boolean showVendorSubTotals) {
		this.showVendorSubTotals = showVendorSubTotals;
	}
	
	
	public String getReportDate()
	{
	    return reportDate;
	}
	public void setReportDate(String reportDate)
	{
	    this.reportDate = reportDate;
	}
	public String getColumnNameForModality()
	{
		if(modality !=  null) {
			return columnMap.get(modality.getValue().replaceAll(" ", ""));
		}
		else {
			return "";
		}
	}
	@Override
	public int hashCode()
	{
	    final int prime = 31;
	    int result = 1;
	    result = prime * result + ((modality == null) ? 0 : modality.hashCode());
	    result = prime * result + ((reportDate == null) ? 0 : reportDate.hashCode());
	    result = prime * result + reportType;
	    result = prime * result + (showVendorSubTotals ? 1231 : 1237);
	    result = prime * result + ((vendor == null) ? 0 : vendor.hashCode());
	    result = prime * result + ((visn == null) ? 0 : visn.hashCode());
	    result = prime * result + ((weekEndingDate == null) ? 0 : weekEndingDate.hashCode());
	    return result;
	}
	@Override
	public boolean equals(Object obj)
	{
	    if (this == obj) return true;
	    if (obj == null) return false;
	    if (getClass() != obj.getClass()) return false;
	    CensusActivityReportParameters other = (CensusActivityReportParameters) obj;
	    if (modality == null)
	    {
		if (other.modality != null) return false;
	    }
	    else if (!modality.equals(other.modality)) return false;
	    if (reportDate == null)
	    {
		if (other.reportDate != null) return false;
	    }
	    else if (!reportDate.equals(other.reportDate)) return false;
	    if (reportType != other.reportType) return false;
	    if (showVendorSubTotals != other.showVendorSubTotals) return false;
	    if (vendor == null)
	    {
		if (other.vendor != null) return false;
	    }
	    else if (!vendor.equals(other.vendor)) return false;
	    
	    
	    if (visn == null)
	    {
		if (other.visn != null) return false;
	    }
	    else if (!visn.equals(other.visn)) return false;
	    
	    
	    
	    if (weekEndingDate == null)
	    {
		if (other.weekEndingDate != null) return false;
	    }
	    else if (!weekEndingDate.equals(other.weekEndingDate)) return false;
	    return true;
	}
	@Override
	public String toString()
	{
	    return "CensusActivityReportParameters [modality=" + modality + ", reportDate=" + reportDate
		    + ", reportType=" + reportType + ", showVendorSubTotals=" + showVendorSubTotals + ", vendor="
		    + vendor + ", weekEndingDate=" + weekEndingDate + "]";
	}
	
	

}
