package gov.va.med.ccht.model.car;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.DateUtils;

public class CensusActivityRecord implements Serializable 
{
	private static final long serialVersionUID = -7932072567700379138L;
	
	private List<TermType> reportWeek = null;
	private String modalityName = null;
	private Integer total = null;
	private Integer nationalTotal = null;
	private List<VendorCensusReportStatus> vendorCensusReportStatus = null;
	
	private Date reportStartDate = null; 
	private Date reportEndDate = null; 
	private String lastDayOfReportWeek = null;
	
	public String getLastDayOfReportWeek() 
	{
		return lastDayOfReportWeek;
	}

	public void setLastDayOfReportWeek(String lastDayOfReportWeek) 
	{
		this.lastDayOfReportWeek = lastDayOfReportWeek;
	}
	
	public void setLastDayOfReportWeek() 
	{		
		GregorianCalendar cal = new GregorianCalendar();  
		cal.setTime(reportEndDate);
		cal.add(Calendar.DATE, 1);
		
		SimpleDateFormat format = new SimpleDateFormat(DateUtils.MMDDYYYY);			
		lastDayOfReportWeek = format.format(cal.getTime());
	}


	
	public List<TermType> getReportWeek() 
	{
		if(reportWeek != null)
		{
			return reportWeek;
		}
		else
		{
			return new ArrayList<TermType>();
		}
	}

	public void setReportWeek(List<TermType> reportWeek) {
		this.reportWeek = reportWeek;
	}
	
	public String getModalityName() 
	{
		if(modalityName != null)
		{
			return modalityName;
		}
		else
		{
			return "No Modality Assigned";
		}
	}
	
	public void setModalityName(String modalityName) 
	{
		this.modalityName = modalityName;
	}
	
	public Integer getTotal() 
	{
		if(total != null)
		{
			return total;
		}
		else
		{
			return 0;
		}
	}
	
	public void setTotal(Integer total) 
	{
		this.total = total;
	}
	
	public Integer getNationalTotal() 
	{
		if(nationalTotal != null)
		{
			return nationalTotal;
		}
		else
		{
			return 0;
		}
	}
	
	public void setNationalTotal(Integer nationalTotal) 
	{
		this.nationalTotal = nationalTotal;
	}
	
	public List<VendorCensusReportStatus> getVendorCensusReportStatus() 
	{
		return vendorCensusReportStatus;
	}

	public void setVendorCensusReportStatus(List<VendorCensusReportStatus> vendorCensusReportStatus) 
	{
		this.vendorCensusReportStatus = vendorCensusReportStatus;
	}

	public Date getReportStartDate() 
	{
		return reportStartDate;
	}


	public void setReportStartDate(Date reportStartDate) 
	{
		this.reportStartDate = reportStartDate;
	}

	
	public Date getReportEndDate() 
	{
		return reportEndDate;
	}

	
	public void setReportEndDate(Date reportEndDate) 
	{
		this.reportEndDate = reportEndDate;		
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((modalityName == null) ? 0 : modalityName.hashCode());
		result = prime * result
				+ ((nationalTotal == null) ? 0 : nationalTotal.hashCode());
		result = prime * result
				+ ((reportEndDate == null) ? 0 : reportEndDate.hashCode());
		result = prime * result
				+ ((reportStartDate == null) ? 0 : reportStartDate.hashCode());
		result = prime * result
				+ ((reportWeek == null) ? 0 : reportWeek.hashCode());
		result = prime * result + ((total == null) ? 0 : total.hashCode());
		result = prime
				* result
				+ ((vendorCensusReportStatus == null) ? 0
						: vendorCensusReportStatus.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityRecord other = (CensusActivityRecord) obj;
		if (modalityName == null) {
			if (other.modalityName != null)
				return false;
		} else if (!modalityName.equals(other.modalityName))
			return false;
		if (nationalTotal == null) {
			if (other.nationalTotal != null)
				return false;
		} else if (!nationalTotal.equals(other.nationalTotal))
			return false;
		if (reportEndDate == null) {
			if (other.reportEndDate != null)
				return false;
		} else if (!reportEndDate.equals(other.reportEndDate))
			return false;
		if (reportStartDate == null) {
			if (other.reportStartDate != null)
				return false;
		} else if (!reportStartDate.equals(other.reportStartDate))
			return false;
		if (reportWeek == null) {
			if (other.reportWeek != null)
				return false;
		} else if (!reportWeek.equals(other.reportWeek))
			return false;
		if (total == null) {
			if (other.total != null)
				return false;
		} else if (!total.equals(other.total))
			return false;
		if (vendorCensusReportStatus == null) {
			if (other.vendorCensusReportStatus != null)
				return false;
		} else if (!vendorCensusReportStatus
				.equals(other.vendorCensusReportStatus))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "CensusActivityRecord [modalityName=" + modalityName + ", nationalTotal="
				+ nationalTotal + ", reportEndDate=" + reportEndDate
				+ ", reportStartDate=" + reportStartDate + ", reportWeek="
				+ reportWeek + ", total=" + total
				+ ", vendorCensusReportStatus=" + vendorCensusReportStatus;
	}
}
