package gov.va.med.ccht.model.car;

import java.io.Serializable;

public class CensusActivityModalityRecord  implements Serializable {

	private static final long serialVersionUID = 8559712330077373237L;
	
	public String facility;
	public String visnName;
	public int visnId;
	public int patientTotals;
	public int selectedModalityTotal;
	public String selectedModalityName;
	public String vendor;
	
	
	public String getVendor() {
		return vendor;
	}

	public void setVendor(String vendor) {
		this.vendor = vendor;
	}
	
	public String getFacility() {
		return facility;
	}

	public void setFacility(String facility) {
		this.facility = facility;
	}

	public String getVisnName() {
		
		return visnName;
	}
	
	public void setVisnName(String visnName) {
		this.visnName = visnName;
	}
	
	public void setVisnName(int visnId) {
		this.visnName = "VISN " + visnId;
	}
	
	
	public int getVisnId() {
		return visnId;
	}
	public void setVisnId(int visnId) {
		this.visnId = visnId;
	}
	public int getPatientTotals() {
		return patientTotals;
	}
	public void setPatientTotals(int patientTotals) {
		this.patientTotals = patientTotals;
	}
	public int getSelectedModalityTotal() {
		return selectedModalityTotal;
	}
	public void setSelectedModalityTotal(int selectedModalityTotal) {
		this.selectedModalityTotal = selectedModalityTotal;
	}
	public String getSelectedModalityName() {
		return selectedModalityName;
	}
	public void setSelectedModalityName(String selectedModalityName) {
		this.selectedModalityName = selectedModalityName;
	}
	
	public void add(CensusActivityModalityRecord recordToAdd)
	{
		patientTotals += recordToAdd.getPatientTotals();
		selectedModalityTotal += recordToAdd.getSelectedModalityTotal();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((facility == null) ? 0 : facility.hashCode());
		result = prime * result + patientTotals;
		result = prime
				* result
				+ ((selectedModalityName == null) ? 0 : selectedModalityName
						.hashCode());
		result = prime * result + selectedModalityTotal;
		result = prime * result + ((vendor == null) ? 0 : vendor.hashCode());
		result = prime * result + visnId;
		result = prime * result
				+ ((visnName == null) ? 0 : visnName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CensusActivityModalityRecord other = (CensusActivityModalityRecord) obj;
		if (facility == null) {
			if (other.facility != null)
				return false;
		} else if (!facility.equals(other.facility))
			return false;
		if (patientTotals != other.patientTotals)
			return false;
		if (selectedModalityName == null) {
			if (other.selectedModalityName != null)
				return false;
		} else if (!selectedModalityName.equals(other.selectedModalityName))
			return false;
		if (selectedModalityTotal != other.selectedModalityTotal)
			return false;
		if (vendor == null) {
			if (other.vendor != null)
				return false;
		} else if (!vendor.equals(other.vendor))
			return false;
		if (visnId != other.visnId)
			return false;
		if (visnName == null) {
			if (other.visnName != null)
				return false;
		} else if (!visnName.equals(other.visnName))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "CensusActivityModalityRecord [facility=" + facility
				+ ", patientTotals=" + patientTotals
				+ ", selectedModalityName=" + selectedModalityName
				+ ", selectedModalityTotal=" + selectedModalityTotal
				+ ", vendor=" + vendor + ", visnId=" + visnId + ", visnName="
				+ visnName + "]";
	}



	
	

}
