/**
 * 
 */
package gov.va.med.ccht.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

import org.hibernate.annotations.Formula;

import gov.va.med.ccht.model.terminology.DocumentType;

/**
 * @author DNS
 *
 */
@MappedSuperclass
public class Attachment extends CCHTAuditFields {

	private Date date = null;
	private DocumentType documentType = null;
	private String documentName = null;

	private String submittedByName = null;

	public Attachment() {
	}

	protected Attachment(Date date, DocumentType documentType, String documentName) {
		this.date = date;
		this.documentType = documentType;
		this.documentName = documentName;
	}

	@Column(name="ATTACHED_DATE")
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	@ManyToOne
	@JoinColumn(name="DOCUMENT_TYPE_ID")
	public DocumentType getDocumentType() {
		return documentType;
	}

	public void setDocumentType(DocumentType documentType) {
		this.documentType = documentType;
	}

	@Column(name="DOCUMENT_NAME")
	public String getDocumentName() {
		return documentName;
	}

	public void setDocumentName(String documentName) {
		this.documentName = documentName;
	}

	// Commented out for now as @Formula can throw a NullPointerException due to a documented bug in Hibernate.
	// Possible work-around is to use SqlResultSetMapping
	//@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	@Transient
	public String getSubmittedByName() {
		return submittedByName;
	}

	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
}