/**
 * 
 */
package gov.va.med.ccht.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AbstractHTEntity implements Serializable {

	private static final long serialVersionUID = -742342338637834541L;
	
	private Long id;
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id", unique = true, nullable = false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#hashCode()
	 */
	public int hashCode() {
		return new HashCodeBuilder().append(this.id).toHashCode();
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		return ((o instanceof AbstractHTEntity) && this.equals((AbstractHTEntity) o));
	}
	
	protected boolean equals(AbstractHTEntity o) {
		return new EqualsBuilder().append(this.getClass(), o.getClass()).append(this.id,
				o.id).isEquals();
	}
}
