package gov.va.med.ccht.jobs;

import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.ccht.service.qir.QIRService;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.model.batchprocess.JobStatus;

public class QIRVendorResponseDueJob extends CchtJob implements Job {

	private Logger logger = Logger.getLogger(getClass());

	@Override
	public void execute(final JobExecutionContext context) throws JobExecutionException {

		JobDAO jobDao = (JobDAO) context.getJobDetail().getJobDataMap().get("jobDao");
		QIRService qirService = (QIRService) context.getJobDetail().getJobDataMap().get("qirService");
		String name = (String) context.getJobDetail().getKey().getName();
		String group = (String) context.getJobDetail().getKey().getGroup();

		logger.info("Alerting of QIR vendor responses due start.");

		JobResult result = saveJobStartingInDatabase(jobDao, group, name, name);

		try {

			qirService.generateVendorResponseDueNotifications();
			saveJobCompletedInDatabase(jobDao, result, JobStatus.COMPLETE);

		} catch (final Exception e) {
			saveJobCompletedInDatabase(jobDao, result, JobStatus.ERROR);
		}

		logger.info("Finished  alerting of QIR vendor responses due.");

	}

}
