package gov.va.med.ccht.jobs;

import java.util.Date;

import com.ibm.icu.util.Calendar;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.model.batchprocess.JobStatus;

public class CchtJob {
    
    public void saveJobCompletedInDatabase(JobDAO jobDao, JobResult result, JobStatus status) {
        result.setEndDate(Calendar.getInstance().getTime());
        result.setStatus(status);
        result.setJobStatus(status.getCode());
        jobDao.saveJobResult(result);
    }
    
    /**
     * 
     * @param jobDao
     * @param context
     * @param runBy hold the username of who ever manually triggered the job, otherwise "-1" 
     * @return 
     */
    public JobResult saveJobStartingInDatabase(JobDAO jobDao, final String group, final String name, String runBy) {
        JobResult result = new JobResult();
        Date currentDate = Calendar.getInstance().getTime();
        result.setGroup(group);
        result.setName(name);
        result.setStartDate(Calendar.getInstance().getTime());
        result.setStatus(JobStatus.IN_PROCESS);
        result.setJobStatus(JobStatus.IN_PROCESS.getCode());
        result.setRecordCreatedDate(currentDate);
        result.setRecordModifiedDate(currentDate);
        result.setRecordModifiedCount((short) 0);
        
        result.setRecordCreatedBy(runBy);
        result.setRecordModifiedBy(runBy);
       
        jobDao.saveJobResult(result);
        return result;
    }
    
}
