package gov.va.med.ccht.controller.validators;

import java.util.List;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.ui.model.UserForm;

@Component
public class ManageUserSearchFormValidator implements Validator {

	@Override
	public boolean supports(Class<?> arg0) {
		
		return UserForm.class.isAssignableFrom(arg0);
	}

	@Override public void validate(Object target, Errors errors) {
		
	}
	
	public void validate(String fName, String lName, String vName, Errors errors) {
		
		String vhaName = vName;		
		String lastName = lName;
		String firstName = fName;
		
		boolean notDirty = true;
		boolean noIdEntered = (vhaName == null || vhaName.isEmpty());
		boolean noLastNameEntered = (lastName == null || lastName.isEmpty());
		
		if(noIdEntered && noLastNameEntered) {
			// User ID or Full Last Name is required.
			if (notDirty) {
				errors.reject("errorblockTitle", "Error Message(s):");
				notDirty = false;
			}
			errors.rejectValue("id", "", "User ID or Full Last Name is required.");
			return;
		}

		
		
		if(!noIdEntered && !noLastNameEntered) {
			
			//Multiple search criteria used.  Please enter either User Id or User Name search, but not both.
			if (notDirty) {
				errors.reject("errorblockTitle", "Error Message(s):");
				notDirty = false;
			}
			errors.rejectValue("id", "", "Multiple search criteria used.  Please enter either User Id or User Name search, but not both.");
			return;
		}
	}
	
	
	public void validateSearchResults(Object target, Errors errors) {
		
		List<User> results = (List<User>)target;
		boolean notDirty = true;
		if(results == null || results.size() == 0) {
			if (notDirty) {
				errors.reject("errorblockTitle", "Error Message(s):");
				notDirty = false;
			}
			errors.rejectValue("id", "", "User not found, Invalid User Id or Name.");
		}
	
	}

}
