package gov.va.med.ccht.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRAttachment;
import gov.va.med.ccht.model.qir.QIRForm;
import gov.va.med.ccht.model.qir.QIRRemarks;
import gov.va.med.ccht.model.qir.QIRSimpleAttachment;
import gov.va.med.ccht.model.qir.QIRType;
import gov.va.med.ccht.model.qir.QIRVendorAction;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.qir.QIRService;
import gov.va.med.ccht.service.report.StandardReportService;
import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.date.TimeZoneUtils;


@Controller
public class ViewQIRPdfController extends CchtController {

	private static final String REPORT_ID = "reportId";
	private static final String ATTACHMENT_ID = "attachmentId";
	private static final String QIR_ID = "qirId";
	private static final String CONTENT_TYPE_APPLICATION_PDF = "application/pdf";
	private static final String CONTENT_TYPE_APPLICATION_CSV = "application/csv";
	private static final String CONTENT_TYPE_APPLICATION_RTF = "application/rtf";
	private static final String CONTENT_TYPE_APPLICATION_XLS = "application/x-excel";
	private static final String QIR_FORM = "VA0729.pdf";
	private StandardReportService standardReportService;
	@Autowired
	private QIRService qirService;
	@Autowired
	private SecurityService securityService;

	private Logger logger = Logger.getLogger(getClass());
	
	@Value("${field.data.overflown}")
	private String fieldDataOverflown;
	
	@RequestMapping(value = "/viewQir.html",  params = {"qirId"},
			method = RequestMethod.GET)
	public String viewQIRPdf(Model model, HttpSession session,
			@RequestParam String qirId,
			HttpServletRequest request, HttpServletResponse response) throws ServiceException, IOException, DocumentException {
		if( StringUtils.isNotEmpty(qirId) ) {
			QIR qir = qirService.getQIR(new Long(qirId));
			if( qir!= null ) {
				QIRType type = qir.getQirType();
				ClassPathResource resource = new ClassPathResource(QIR_FORM);
				
				InputStream inStream = null;
				PdfReader reader = null;
				ByteArrayOutputStream output = null;
				PdfStamper stamper = null;
				
				//Add try and finalize to fix Fortify Issue
				try {	
					
					inStream = resource.getInputStream();
					reader = new PdfReader(resource.getInputStream());
					output = new ByteArrayOutputStream();
					stamper = new PdfStamper(reader, output);
										
					stamper.setFormFlattening(true);
					AcroFields form = stamper.getAcroFields();
					HashMap<String, String> fields = form.getFields();
					
					Set<String> keys = fields.keySet();
					
					StringBuffer actionText = new StringBuffer();
					String cleanActionText = "";
					StringBuffer complaintText = new StringBuffer();
					StringBuffer remarkText = new StringBuffer();
					
					int count = 0;
					for( String field : keys ) {
						String fvalue = form.getField(field);
						count++;
						if(count == 28) { // cannot find name of field, works until best solution is found.
							
							form.setField(field, ESAPIValidator.validateStringInput(qir.getSummary(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));						
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.ORIG_ROLE) ) {
							User user = securityService.getUser(qir.getRecordCreatedBy());
							
							if(user != null) {
								RegistrationReason reason = user.getRegistrationReason();							
								if(reason != null) {
									String name = ESAPIValidator.validateStringInput(reason.getName(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT);
									form.setField(field, name);
								}							
							}
							else {
								form.setField(field, "None");
							}						
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.SERIAL_NO) ) {						
							form.setField(field, ESAPIValidator.validateStringInput(qir.getSerialNumber(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.CONTRACT_NO) ) {
							if(qir.getPurchaseOrderNumber() != null) {
								form.setField(field, ESAPIValidator.validateStringInput(qir.getPurchaseOrderNumber(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
							}
							else {
								form.setField(field, "None");
							}
							
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.ORIG_VISN) ) {						
							String name = "";
							if(qir.getVisn() != null) {
								name = qir.getVisn().getName();
							}						
							form.setField(field, ESAPIValidator.validateStringInput(name, ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.ORIG_FACILITY) ) {						
							String facility = "";
							if(qir.getFacility() != null) {
								facility = qir.getFacility().getName();
							}						
							form.setField(field, ESAPIValidator.validateStringInput(facility, ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.ORIG_NAME) ) {						
							form.setField(field, ESAPIValidator.validateStringInput(qir.getSubmittedByName(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.MODEL_NO) ) {
							String modelString = "";								
							if(	qir.getDeviceType() != null ){ 
								modelString = qir.getDeviceType().getName();
							}
							modelString = StringUtils.replace(modelString, "Version ", "V.");
							form.setField(field, ESAPIValidator.validateStringInput(modelString, ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( type != null ) {
							// Quality of Complaint
							if( StringUtils.equalsIgnoreCase(field, QIRForm.QUALITY_COMPLAINT) ) {
								if( StringUtils.equalsIgnoreCase(type.getCode(), QIRType.QUALITY_COMPLAINT) ) {
									form.setField(field, "1");
								}
							}
							// New Item
							if( StringUtils.equalsIgnoreCase(field, QIRForm.NEW_ITEM) ) {
								if( StringUtils.equalsIgnoreCase(type.getCode(), QIRType.NEW_ITEM) ) {
									form.setField(field, "1");
								}
							}
							// Similar Item
							if( StringUtils.equalsIgnoreCase(field, QIRForm.SIMILAR_ITEM) ) {
								if( StringUtils.equalsIgnoreCase(type.getCode(), QIRType.SIMILAR_ITEM) ) {
									form.setField(field, "1");
								}
							}
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.VENDOR) ) {
							
							String name = "";
							
							if(qir.getVendor() != null) {
								name = qir.getVendor().getName();
							}
							
							form.setField(field, ESAPIValidator.validateStringInput(name.trim(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.MM_DD_YYYY) ) {
							DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
							form.setField(field, formatter.format(qir.getRecordCreatedDate()));
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.TN) ) {						
							form.setField(field, ESAPIValidator.validateStringInput(String.valueOf(qir.getId()), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT));
						}
						
						// Handle fields that could exceed the field limit
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.VENDOR_ACTION) ) {
							//Vendor Actions
							actionText = new StringBuffer();
							List<QIRVendorAction> actions = new ArrayList<QIRVendorAction>(qir.getVendorActions());
							Collections.sort(actions, Collections.reverseOrder());
							for (QIRVendorAction action:actions) {
								actionText.append( TimeZoneUtils.convertDateToTimeZone(action.getDate(), TimeZone.getDefault()))
	  									  .append( ", " )
										  .append( action.getSubmittedByName() )
										  .append( ": " )
										  .append( action.getAction() )
										  .append( "\n" );
							}
							if( actions.isEmpty() ) {
								actionText.append("None");
							}
							// A limit of characters in a vendor action field is QIRForm.TEXT_OVERFLOW_LIMIT
							if( actionText.toString().length() <= QIRForm.TEXT_OVERFLOW_LIMIT ) {
								validateAndSetFeild(field, actionText, form);
							}
							else {
								form.setField(field, fieldDataOverflown);
							}
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.CAUSE_OF_COMPLAINT) ) {
							complaintText.append((qir.getComplaint() != null ? qir.getComplaint() : ""));
							if( complaintText.length() <= QIRForm.TEXT_OVERFLOW_LIMIT ) {
								validateAndSetFeild(field, complaintText, form);
							}
							else {
								form.setField(field, fieldDataOverflown);
							}
						}
						if( StringUtils.equalsIgnoreCase(fvalue, QIRForm.REC_REMARKS) ) {
							
							//Remarks
							remarkText = new StringBuffer();
							List<QIRRemarks> remarks = new ArrayList<QIRRemarks>(qir.getRemarks());
							Collections.sort(remarks, Collections.reverseOrder());
							for (QIRRemarks remark : remarks) {
								remarkText.append( TimeZoneUtils.convertDateToTimeZone(remark.getDate(),TimeZone.getDefault()) )
									      .append( ", " )
									      .append( remark.getSubmittedByName() )
									      .append( ": " )
									      .append( remark.getRemarks() )
									      .append( "\n" );
							}
							if( remarks.isEmpty() ) {
								remarkText.append("None");
							}
							if( remarkText.length() <= QIRForm.TEXT_OVERFLOW_LIMIT ) {
								form.setField(field, remarkText.toString());
							}
							else {
								form.setField(field, fieldDataOverflown);
							}
						}
					}
					
					// Add attachment appendix
					Set<QIRSimpleAttachment> attachments = qir.getAttachments();
					StringBuffer info = new StringBuffer();
					for( QIRSimpleAttachment attachment : attachments ) {
						
						info.append(TimeZoneUtils.convertDateToTimeZone(attachment.getRecordCreatedDate(),TimeZone.getDefault()))
							.append(", ")
							.append(attachment.getDocumentName())
							.append("\n");
					}
					if( attachments.isEmpty() ) {
						info.append("None");
					}
					addAppendix("Attachment(s)",info.toString(),stamper,reader);	
	
					// Add cause of complaint appendix
					if( complaintText.length() > QIRForm.TEXT_OVERFLOW_LIMIT ) {
						addAppendix("Cause of Complaint(s)",complaintText.toString(),stamper,reader);	
					}
									
					// Add Vendor Action appendix
					if( actionText.length() > QIRForm.TEXT_OVERFLOW_LIMIT ) {
						addAppendix("Vendor Action(s)",actionText.toString(),stamper,reader);	
					}
					// Add remarks appendix
					if( remarkText.length() > QIRForm.TEXT_OVERFLOW_LIMIT ) {
						addAppendix("Remark(s)",remarkText.toString(),stamper,reader);	
					}
					
					stamper.close();
					reader.close();
					output.flush();
										
			        final String formName = qir.getId() + ".pdf";
			        response.setHeader("Content-Disposition", "attachment; filename=" + formName);
					writeReportToReponse(addPageNumber(output,qir).toByteArray(), CONTENT_TYPE_APPLICATION_PDF, response);
				}finally  {
					if(stamper != null)	{
						safeCloseStamper(stamper);
					}
					if(reader != null) {
						safeCloseReader(reader);
					}
					if(output != null) {
						safeCloseOutput(output);
					}	
					if(inStream != null) {
						safeCloseInStream(inStream);
					} 
				}
			}
		}
		return null; 
	}

	@RequestMapping(value = "/viewQir.html",  params = {"attachmentId"},
			method = RequestMethod.GET)
	public String viewAttachment(Model model, HttpSession session,
			@RequestParam String attachmentId,
			HttpServletRequest request, HttpServletResponse response) throws ServiceException, IOException {	
		if (StringUtils.isNotEmpty(attachmentId)){
			QIRAttachment qirAttachment = qirService.getQIRAttachment(new Long(attachmentId));
			if (qirAttachment != null) {
				String[] acceptedImageExtentions = {"jpg","jpeg","png"};
				// not allowed, may contain possible XSS
				String[] forbiddenFileTypes = {"htm", "html", "txt"};
				String documentName = qirAttachment.getDocumentName();
				String fileExtension = documentName.substring(documentName.lastIndexOf(".")+1);
				String fileType = "";
				boolean image = false;
				
				for(int i = 0; i < acceptedImageExtentions.length; i++) {
					if(acceptedImageExtentions[i].equalsIgnoreCase(fileExtension)) {
						image = true;
					}
					// Fortify: simply do not allow document to get sent to browser. 
					// we also do not allow user to even upload files the the extentions txt, htm, or html. 
					// logic found in inc_attachmentTable.jsp
					if(forbiddenFileTypes[i].equalsIgnoreCase(fileExtension)) {
						// risky file type detected. Return without opening file.
						return null;
					}
					continue;	
				}
				
				 //Fix Fortify Issues
				ESAPIValidator.validateStringInput(documentName, ESAPIValidationType.DocumentName_Whitelist);
							
				response.setHeader("X-Content-Type-Options", "nosniff");
				response.setHeader("X-XSS-Protection", "1");
				response.setHeader("Content-Disposition", "attachment; filename=" + documentName);
				
				// determine MIME type
				if (image) {
					fileType = "image/" + fileExtension;
				} else {
					fileType = "application/" + fileExtension;
				}
				this.writeReportToReponse(qirAttachment.getData(), fileType, response);
			}
		}
		return null;
	}
	
	private void addAppendix( String title, String text, PdfStamper stamper, PdfReader reader ) throws DocumentException {
		
		ColumnText ct = new ColumnText(null);
		ct.addElement( new Paragraph(24, text, FontFactory.getFont(FontFactory.HELVETICA,10)) );

		int i = reader.getNumberOfPages();
        while(true) {
            // Add a new page
            stamper.insertPage(++i, reader.getPageSize(1));

            // Insert a header
            getHeaderTable(title).writeSelectedRows(0, -1, 34, 780, stamper.getOverContent(i));
            
            // Add as much content of the column as possible
            ct.setCanvas(stamper.getOverContent(i));
            ct.setSimpleColumn(36, 36, 559, 760);
            if (!ColumnText.hasMoreText(ct.go()))
                break;
        }
	}
	
	private void validateAndSetFeild(String field, StringBuffer value, AcroFields form) throws ServiceException, IOException, DocumentException{
		String[] valueLineArray = StringUtils.split(value.toString(), "\n");
		String cleanValue = "";
				
		for(int i = 0; i < valueLineArray.length; i++) {
				if(i != 0)
					cleanValue = cleanValue + "\n" + ESAPIValidator.validateStringInput(valueLineArray[i].trim(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT);
				else
					cleanValue =  ESAPIValidator.validateStringInput(valueLineArray[i].trim(), ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT);
			}
		form.setField(field, cleanValue);
	}
	
	private ByteArrayOutputStream addPageNumber(ByteArrayOutputStream output, QIR qir) throws IOException,DocumentException,ServiceException {
		
		// Insert page number
		PdfReader reader = new PdfReader(output.toByteArray());
		int pages = reader.getNumberOfPages();
		
		Document document = new Document();
		ByteArrayOutputStream result = new ByteArrayOutputStream();
		PdfCopy copy = new PdfCopy(document,result);
		document.open();
		
		PdfImportedPage page;
        PdfCopy.PageStamp stamp;
        for (int i = 0; i < pages; i++) {
            page = copy.getImportedPage(reader, (i+1));
            stamp = copy.createPageStamp(page);
            
            // add page numbers
            ColumnText.showTextAligned(
                    stamp.getUnderContent(), Element.ALIGN_RIGHT,
                    new Phrase(String.format("Page %d of %d", (i+1), pages),FontFactory.getFont(FontFactory.HELVETICA,8)),
                      580.5f, 28, 0);
            stamp.alterContents();
            copy.addPage(page);
        }
        
        // Insert attachments into the document
		Set<QIRSimpleAttachment> attachments = qir.getAttachments();
		for( QIRSimpleAttachment attachment : attachments ) {
			QIRAttachment qirAttachment = qirService.getQIRAttachment(new Long(attachment.getId()));
			
	        PdfFileSpecification fs
	          = PdfFileSpecification.fileEmbedded(copy, null, qirAttachment.getDocumentName(), qirAttachment.getData());
	        copy.addFileAttachment(fs);
		}
        copy.close();
        document.close();
        result.close();
        return result;
	}
	
	private PdfPTable getHeaderTable( String title ) {
        PdfPTable table = new PdfPTable(1);
        table.setTotalWidth(527);
        table.setLockedWidth(true);
        table.getDefaultCell().setFixedHeight(20);
        table.getDefaultCell().setBorder(Rectangle.BOTTOM);
        table.addCell( new Phrase("Appendix - " + title, FontFactory.getFont(FontFactory.HELVETICA,10)) );
        return table;
    }

	public Logger getLogger() {
		return logger;
	}

	public void setLogger(Logger logger) {
		this.logger = logger;
	}
	
	protected void writeReportToReponse(byte buffer[], String contentType,
			HttpServletResponse response) throws IOException {
		try {
			response.setHeader("X-Content-Type-Options", "nosniff");
			response.setHeader("X-XSS-Protection", "1");
			// Fix Fortify issue.
		   ESAPIValidator.validateStringInput(contentType, ESAPIValidationType.ContentType_Whitelist);
			
		response.setContentType(contentType);
		OutputStream outStream = response.getOutputStream();
		outStream.write(buffer);
		outStream.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void writeMessageToReponse(String msg, HttpServletResponse response)
			throws IOException {
		PrintWriter writer = response.getWriter();
		String message = "";
		
		try {
			message = ESAPIValidator.validateStringInput(msg, ESAPIValidationType.CROSS_SITE_SCRIPTING_PERSISTENT);
		}
		catch(Exception e) {
			throw new IOException(e.getMessage());
		}
		writer.write(message);
		writer.close();
	}
	
	// required Close methods for Fortify:
	public static void safeCloseStamper(PdfStamper stamper) {
		  if (stamper != null) {
		    try {
		    	stamper.close();
		    } catch (Exception e) {
		    }
		  }
	}
	public static void safeCloseInStream(InputStream inStream) {
		  if (inStream != null) {
		    try {
		    	inStream.close();
		    } catch (IOException e) {
		    }
		  }
	}
	public static void safeCloseReader(PdfReader reader) {
		  if (reader != null) {
		    try {
		    	reader.close();
		    } catch (Exception e) {
		    }
		  }
	}
	public static void safeCloseOutput(ByteArrayOutputStream output) {
		  if (output != null) {
		    try {
		    	output.flush();
		    } catch (Exception e) {
		    }
		  }
	}
}
