package gov.va.med.ccht.controller;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.terminology.InactiveReason;
import gov.va.med.ccht.model.terminology.RegistrationDeniedReason;
import gov.va.med.ccht.model.terminology.RegistrationReason;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.model.terminology.UserGroup;
import gov.va.med.ccht.service.common.TerminologyCache;

@Controller
public class TerminologyCacheController {

	@Autowired
	private TerminologyCache terminologyCache;

	public Map<String, String> getUserGroups() throws Exception {
		Map<String, String> userGroupMap = new HashMap<String, String>();
		@SuppressWarnings("unchecked")
		List<UserGroup> userGroupList = (List<UserGroup>) terminologyCache.getTerminologyService()
				.findAll("gov.va.med.ccht.model.terminology.UserGroup");

		for (UserGroup userGroup : userGroupList) {
			userGroupMap.put(userGroup.getCode(), userGroup.getName());
		}
		return userGroupMap;
	}

	public Map<String, String> getJobDescriptions() throws Exception {
		Map<String, String> jobDescriptionMap = new HashMap<String, String>();
		@SuppressWarnings("unchecked")
		List<RegistrationReason> jobDescriptionList = (List<RegistrationReason>) terminologyCache
				.getTerminologyService().findAll("gov.va.med.ccht.model.terminology.RegistrationReason");

		for (RegistrationReason jobDescription : jobDescriptionList) {
			jobDescriptionMap.put(jobDescription.getCode(), jobDescription.getName());
		}
		return jobDescriptionMap;
	}

	public List<InactiveReason> getInactivationReasons() throws Exception {
		@SuppressWarnings("unchecked")
		List<InactiveReason> inactiveReasonsList = (List<InactiveReason>) terminologyCache.getTerminologyService()
				.findAll("gov.va.med.ccht.model.terminology.InactiveReason");

		return inactiveReasonsList;
	}

	public Map<String, RegistrationStatus> getRegistrationStatusLookUpMap() throws Exception {
		Map<String, RegistrationStatus> registrationStatusMap = new HashMap<String, RegistrationStatus>();
		@SuppressWarnings("unchecked")
		List<RegistrationStatus> registrationStatusList = (List<RegistrationStatus>) terminologyCache
				.getTerminologyService().findAll("gov.va.med.ccht.model.terminology.RegistrationStatus");

		for (RegistrationStatus status : registrationStatusList) {
			registrationStatusMap.put(status.getCode(), status);
		}
		return registrationStatusMap;
	}

	public Map<Long, String> getRegistrationStatus(Map<Integer, RegistrationStatus> arg) throws Exception {
		Map<Long, String> registrationStatusMap = new HashMap<Long, String>();

		for (Map.Entry<Integer, RegistrationStatus> entry : arg.entrySet()) {
			RegistrationStatus status = entry.getValue();
			registrationStatusMap.put(status.getId(), status.getName());
		}
		return registrationStatusMap;
	}

	public Map<String, RegistrationDeniedReason> getRegistrationDeniedLookUpMap() throws Exception {
		Map<String, RegistrationDeniedReason> registrationDeniedReasonMap = new HashMap<String, RegistrationDeniedReason>();
		@SuppressWarnings("unchecked")
		List<RegistrationDeniedReason> registrationStatusList = (List<RegistrationDeniedReason>) terminologyCache
				.getTerminologyService().findAll("gov.va.med.ccht.model.terminology.RegistrationDeniedReason");

		for (RegistrationDeniedReason status : registrationStatusList) {
			registrationDeniedReasonMap.put(status.getCode(), status);
		}
		return registrationDeniedReasonMap;
	}

	public Map<Long, String> getRegistrationDeniedReasons(Map<Integer, RegistrationDeniedReason> deniedReasonMap) throws Exception {
		Map<Long, String> registrationDeniedReasons = new HashMap<Long, String>();
		registrationDeniedReasons.put(new Long(-1), "Select");

		for (Map.Entry<Integer, RegistrationDeniedReason> entry : deniedReasonMap.entrySet()) {
			RegistrationDeniedReason status = entry.getValue();
			registrationDeniedReasons.put(status.getId(), status.getName());
		}
		return registrationDeniedReasons;
	}

	public Map<Integer, String> getFacilities() throws Exception {
		Map<Integer, String> facilities = new LinkedHashMap<Integer, String>();
		@SuppressWarnings({ "unchecked" })
		SortedSet<Facility> facilityList = new TreeSet<>((List<Facility>) terminologyCache.getTerminologyService()
				.findAll("import gov.va.med.ccht.model.inventory.Facility"));

		for (Facility status : facilityList) {
			facilities.put(status.getId(), status.getName());
		}
		return facilities;
	}
}
