package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.visn.VisnService;
import gov.va.med.ccht.ui.model.UserForm;
import gov.va.med.ccht.util.ESAPIValidationType;
import gov.va.med.ccht.util.ESAPIValidator;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.service.ServiceException;

@Controller
public class ManageUserSearchController extends CchtController {
	
@Autowired
VisnService visnSerive;
@Autowired
SecurityService securityService;

    @InitBinder
    public void initBinder(WebDataBinder binder)
    {   
    	String[] allowedFields = {"id", "userName", "lastName", "firstName", "selectedVisn"};
    	binder.setAllowedFields(allowedFields);    	
    }

	@RequestMapping(value = "/manageUsersSearch.html", method = RequestMethod.GET)
	public String showManageUser(@ModelAttribute("command") UserForm command, Model model) throws Exception {
		addVisnSelection(model);
		return "manageUsersSearch";
	}

	@RequestMapping(value = "/manageUsersSearchForm.html", method = { RequestMethod.GET }, params = { "Search" })
	public String showSelectedUser(@ModelAttribute("command") UserForm command, BindingResult result, Model model)
			throws Exception {

		SearchCriteria criteria = new SearchCriteria();

		// Build criteria object so we can search by the users input

		if (command.getId() != null && command.getId().length() > 0) {
			// User has opted to search by user id (vha...)
			criteria.setUserID(command.getId());
		} 
		else if(command.getLastName() != null && command.getLastName().length() > 0) {
			// User has opted to search by last name
			criteria.setLastName(command.getLastName());

			// User has also opted to further filter by first name.
			if (command.getFirstName() != null && command.getFirstName().length() > 0) {
				criteria.setFirstName(command.getFirstName());
			}
		}
		else if(!command.getSelectedVisn().equals("-1")) {
			
			int visnId = visnSerive.getVisn(command.getSelectedVisn()).getId();
			List<User> cchtUsers = securityService.getUsersByVisn(visnId);
			model.addAttribute("users", cchtUsers);
			return "userSearchResult";
		}

		// Get a list of users according to criteria.
		List<User> cchtUsers = securityService.findAppUsers(criteria);
		
		// Users have been found.
		// found users create UserForm object(s) to display.
		if (cchtUsers.size() > 1) {
			model.addAttribute("users", cchtUsers);
			return "userSearchResult";
		} else if (cchtUsers.size() == 1) {
			// One User Found
			User user = cchtUsers.get(0);
			// First validate userName against very restrictive and minimal white list.
			String userName = ESAPIValidator.validateStringInput(user.getUsername(), ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList);
			// redirectStr does not need to be validated because it is defined by predefined/hardcoded basePath and other hardcoded values.
			// The userName portion of the redirectStr is validated above.
			String redirectStr = "redirect:" + basePath + "ShowManageUsersEdit.html?userName=" + userName + "&fromPage=userSearch";
			
			// show edit page.
			return redirectStr;
		}
		else if(cchtUsers == null || cchtUsers.size() < 1) {
			model.addAttribute("showNoRecordsError", true);
			addVisnSelection(model);
		}

		return "manageUsersSearch";
	}

	private void addVisnSelection(Model model) throws ServiceException {
		List<SimpleVisn> allVisns = visnSerive.getSimpleVisns();
		List<String> allVisnNames = new ArrayList<String>();
		for(SimpleVisn visn : allVisns) {
			allVisnNames.add(ESAPIValidator.validateStringInput(visn.getName(), ESAPIValidationType.UpperAndLowerCaseWithNumbers_WhiteList));
		}
		model.addAttribute("visns", allVisnNames);
	}
}
