package gov.va.med.ccht.controller;

import java.util.TimeZone;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import gov.va.med.ccht.model.CCHTRoles;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.ui.interceptor.CommonReferenceDataInterceptor;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.date.TimeZoneUsageMode;
import gov.va.med.fw.util.date.TimeZoneUtils;

@Controller
public class HomeController {
	private static final Logger log = LoggerFactory.getLogger(HomeController.class);

    @Value("${session.expirationSeconds}")
	private int sessionExpirationSeconds;
	
	private int autoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving;
	private Boolean autoDetectedUserTimeZoneObservesDaylightSaving;
	private TimeZoneUsageMode explicitTimeZoneUsageMode;
	

	@RequestMapping("/keepAlive")
	public @ResponseBody boolean keepAlive() {
		log.debug("Received request to keep-alive the session...");
		return true;
	}

	protected TimeZone initUserTimeZone() throws LoginException {
		Integer sessionTimeZone = null;

		sessionTimeZone = autoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving;

		TimeZone userTimeZone = TimeZoneUtils.getTimeZone(sessionTimeZone,
				autoDetectedUserTimeZoneObservesDaylightSaving);

		return userTimeZone;
	}
	
	@RequestMapping(value = "/home.html", method = RequestMethod.GET)
	public String goHome(HttpSession session) throws Exception {
		User user = CommonReferenceDataInterceptor.getCurrentUserAsOrNull(User.class);
		
		String userStatus = user.getRegistrationStatus().getCode();
			
		if(userStatus.equalsIgnoreCase(RegistrationStatus.SUBMITTED)) {
			LoginController.hideWelcomeBar();
			return "pendingRegistration";
		}
		
		if(userStatus.equalsIgnoreCase(RegistrationStatus.REJECTED)) {
			LoginController.hideWelcomeBar();
			return "registrationDenied";
		}

		if(userStatus.equalsIgnoreCase(RegistrationStatus.UNDER_REVIEW)) {
			LoginController.hideWelcomeBar();
			return "userUnderReview";
		}
		
		if(userStatus.equalsIgnoreCase(RegistrationStatus.OTHER)) {
			LoginController.hideWelcomeBar();
			//TODO: make page to display reason user is not allowed in.
			return "userUnderReview";
		}
		
		if(user.isAccountLocked()) {
			LoginController.hideWelcomeBar();
			return "locked";
		}
		
		if(user.isInactive()) {
			LoginController.hideWelcomeBar();
			return "inactive";
		}
		
		// TimeZone currentTimeZone = initUserTimeZone();
		// TimeZoneUtils.setThreadCurrentTimezone(currentTimeZone);
		session.setMaxInactiveInterval(sessionExpirationSeconds);
		LoginController.setMenuVisibilityByPermissions();
		return "home";
	}

	@RequestMapping(value = "/locked.html", method = RequestMethod.GET)
	public String showLocked() throws Exception {
		return "locked";
	}
	
	@RequestMapping(value = "/error.html", method = RequestMethod.GET)
	public String showError() throws Exception {
		return "error";
	}

	@RequestMapping(value = "/errorFileSize.html", method = RequestMethod.GET)
	public String showErrorFileSizeExceeded() throws Exception {
		return "errorFileSize";
	}

	@RequestMapping(value = "/help.html", method = RequestMethod.GET)
	public String showHelp(Model model) throws Exception {

		SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
		UserPrincipal currentUser = securityContext.getUserPrincipal();
		boolean showAdminHelp = true;
		if (currentUser.isPermissionGranted(CCHTRoles.VENDOR)) {
			showAdminHelp = false;
		}
		boolean showInventoryHelp = true;
		if (currentUser.isPermissionGranted(CCHTRoles.VENDOR)) {
			showInventoryHelp = false;
		}
		boolean showQirHelp = true;

		boolean showReportsOnlyHelp = false;
		if (currentUser.isPermissionGranted(CCHTRoles.REPORTS_ONLY)) {
			// showReportsOnlyHelp = true;
			showAdminHelp = false;
			showQirHelp = false;
			showInventoryHelp = false;
		}

		model.addAttribute("showAdminHelp", showAdminHelp);
		model.addAttribute("showInventoryHelp", showInventoryHelp);
		model.addAttribute("showQirHelp", showQirHelp);
		model.addAttribute("showReportsOnlyHelp", showReportsOnlyHelp);
		// Forced to false until we deploy HT Reports
		model.addAttribute("showReportsHelp", true);
		return "help";
	}

	public void setAutoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving(
			int autoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving) {
		this.autoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving = autoDetectedUserTimeZoneRawOffsetWithoutDaylightSaving;
	}

	public void setAutoDetectedUserTimeZoneObservesDaylightSaving(
			Boolean autoDetectedUserTimeZoneObservesDaylightSaving) {
		this.autoDetectedUserTimeZoneObservesDaylightSaving = autoDetectedUserTimeZoneObservesDaylightSaving;
	}

	public void setExplicitTimeZoneUsageMode(TimeZoneUsageMode explicitTimeZoneUsageMode) {
		this.explicitTimeZoneUsageMode = explicitTimeZoneUsageMode;
	}

}
