/*package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.persistent.VisnDAO;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class VisnDAOImplIntTest {
	
	@Autowired
	private VisnDAO visnDAO;
	
	private final static String UNIT_TEST_NAME = "unit_test";
	
	@Before
	public void before() {
		cleanupDatabase();		 
	}
	
	@After
	public void after() {
		cleanupDatabase();
	}
	
	private void cleanupDatabase() {
		
		visnDAO.getVisns().forEach(visn -> {
			if (visn.getName().contains(UNIT_TEST_NAME)) {
				visnDAO.deleteVisn(visn);
			}
		});

	}
	
	@Test
	public void testGetVisn() {
		
		final List<Visn> visns = visnDAO.getVisns();
		
		assertNotNull(visns);
		
		final int sizeBeforeUnitTest = visns.size();
		
		final Visn visn = new Visn();
		visn.setName(UNIT_TEST_NAME);
		
		visnDAO.insertVisn(visn);
		
		assertTrue(visnDAO.getVisns().size() == sizeBeforeUnitTest + 1);
		assertTrue(visnDAO.getSimpleVisns().size() == sizeBeforeUnitTest + 1);
		
		visnDAO.deleteVisn(visn);

		assertTrue(visnDAO.getVisns().size() == sizeBeforeUnitTest);
		
	}

}
*/