package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import gov.va.med.ccht.model.pssreport.VendorSubmissionReportData;
import gov.va.med.ccht.persistent.VendorSubmissionReportDAO;

public class VendorSubmissionReportDAOImplTest {
	private static final Integer TEST_INTEGER = 0;

	static final private int VENDOR_NAME = 0;
	static final private int DATE = 1;
	static final private int NUM_DAYS_SINCE_SUB = 2;
	static final private int SURVEY_TOTAL = 3;
	static final private int SURVEY_ID = 4;
	
	static final private int SURVEY_ID_PS_VERION_ONE = 2;
	static final private int SURVEY_ID_PS_VERION_TWO = 3;
	
	static final private Date TEST_DATE = new Date();
	
	@Mock
	private SessionFactory sessionFactory;
	@Mock
	private Session session;
	@Mock
	private NativeQuery<Session> nQuery;
	
	private VendorSubmissionReportDAO vendorReport;
	
	private List<Object[]> emptyTestRows;
	private List<VendorSubmissionReportData> result;
	
	@Before
	public void setup() {
		MockitoAnnotations.initMocks(this);
		
		Mockito.doReturn(session).when(sessionFactory).getCurrentSession();
		Mockito.doReturn(nQuery).when(session).createNativeQuery(Mockito.anyString());
		vendorReport = new VendorSubmissionReportDAOImpl(sessionFactory);
		emptyTestRows = new ArrayList<>();
	}
	
	@Test
	public void getVendorSubmissionReportDataWithEmptyDateShouldReturn1RecordForTotalVendorsZeroSurveys(){
		Mockito.doReturn(emptyTestRows).when(nQuery).getResultList();
		result = vendorReport.getVendorSubmissionReport();
		assertTrue(result.size() == 1);
		assertTrue(result.get(0).getTotalNumberOfSurveys().equals("0"));
		assertTrue(result.get(0).getVendorName().equals("Total for All Vendors"));
	}
	
	@Test
	public void getVendorSubmissionReportDataWith3VendorRowsOfDataShouldReturn4RowsOfData(){
		int totalSurveyCount = 0;
		List<Object[]> testRows= new ArrayList<>();
		for(int i = 0; i < 3; i++){
			Object[] row = new Object[5];
			row[VENDOR_NAME] = TEST_INTEGER + i;
			row[DATE] = new Date();
			row[NUM_DAYS_SINCE_SUB] = TEST_INTEGER + i;		
			row[SURVEY_TOTAL] = TEST_INTEGER + i;
			totalSurveyCount += (int)row[SURVEY_TOTAL];
			row[SURVEY_ID] = SURVEY_ID_PS_VERION_ONE;
			testRows.add(row);
		}
		for(int i = 0; i < 3; i++){
			Object[] row = new Object[5];
			row[VENDOR_NAME] = TEST_INTEGER + i;
			row[DATE] = TEST_DATE;		
			row[NUM_DAYS_SINCE_SUB] = TEST_INTEGER + i;
			row[SURVEY_TOTAL] = TEST_INTEGER + i;
			totalSurveyCount += (int)row[SURVEY_TOTAL];
			row[SURVEY_ID] = SURVEY_ID_PS_VERION_TWO;
			testRows.add(row);
		}
		
		Mockito.doReturn(testRows).when(nQuery).getResultList();
		result = vendorReport.getVendorSubmissionReport();
		assertTrue(result.size() == 4);
		assertTrue(result.get((result.size() - 1)).getVendorName().equals("Total for All Vendors"));
		assertTrue(result.get((result.size() - 1)).getTotalNumberOfSurveys().equals("" + totalSurveyCount));
	}
}