/*package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Calendar;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.persistent.VendorDAO;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class VendorDAOImplIntTest {

	@Autowired
	private VendorDAO vendorDAO;

	private final static String UNIT_TEST_NAME = "unit_test";

	@Before
	public void before() {
		cleanupDatabase();
	}

	@After
	public void after() {
		cleanupDatabase();
	}

	private void cleanupDatabase() {
		vendorDAO.getActiveVendors().forEach(vendor -> {
			if (vendor.getName().equals(UNIT_TEST_NAME)) {
				vendorDAO.deleteVendor(vendor);
			}
		});
	}
	
	@Test
	public void testGetVendors() {
		 
		final List<Vendor> vendors = vendorDAO.getActiveVendors();
		
		assertNotNull(vendors);
		
		final int sizeBeforeUnitTest = vendors.size();
		
		final Vendor v = new Vendor();
		v.setName(UNIT_TEST_NAME);
		v.setNumber(UNIT_TEST_NAME);
		v.setDateActive(Calendar.getInstance().getTime());
		
		vendorDAO.insertVendor(v);
		
		assertEquals((sizeBeforeUnitTest + 1), vendorDAO.getActiveVendors().size());
		
		final Vendor foundVendor = vendorDAO.getVendor(v.getName());
		assertEquals(v.getName(), foundVendor.getName());
		assertEquals(v.getId(), foundVendor.getId());
		assertEquals(v.getNumber(), foundVendor.getNumber());
		
		vendorDAO.deleteVendor(v);

		assertTrue(vendorDAO.getActiveVendors().size() == sizeBeforeUnitTest);

	}

}
*/