/*package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.model.SimpleUser;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.terminology.RegistrationStatus;
import gov.va.med.ccht.persistent.SecurityDAO;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.security.UserPrincipal;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class SecurityDAOIntTest {
	
	private static final String TEST_PERMISSION_NAME = "testPermission";
	private static final String TEST_DESCRIPTION = "testDescription";
	private static final String TEST_ROLE_NAME = "testUserRole";
	private static final String TEST_USER_NAME = "testUser";
	private static final Date TEST_DATE = Calendar.getInstance().getTime();
	
	@Autowired
	SecurityDAO securityDao;

	@Before
	public void setup() {
		
	}
	
	@After
	public void teardown() {
		final Role role = new Role();
		role.setName(TEST_ROLE_NAME);
		securityDao.remove(role);
	}
	
	@Test
	public void testDAONotNull() {
		assertNotNull(securityDao);
	}
	
	@Test
	public void testGetUserByNameNotEmpty() throws DAOException {
		final User user = securityDao.getUserByName("ihtaAdmin");
		assertNotNull(user);
		assertEquals("ihtaadmin", user.getFirstName());
	}
	
	@Test
	public void testGetSubmittedRegistrations() {
		final List<User> regListNoIds = securityDao.getSubmittedRegistrations(null, null);
		assertNotNull(regListNoIds);
		assertTrue(regListNoIds.size() > 0);
		// Assumes that DNS is not approved.
		assertTrue(regListNoIds.contains(new User("DNS")));
		for(int i = 0; i < regListNoIds.size(); i++) {
			assertTrue(!regListNoIds.get(i).getRegistrationStatus().equals(RegistrationStatus.APPROVED));
		}
		
		final List<User> regListFac = securityDao.getSubmittedRegistrations(null, new Integer(1));
		assertNotNull(regListFac);
		assertTrue(regListFac.size() == 1);
		assertTrue(regListFac.contains(new User("DNS")));
		assertTrue(!regListFac.get(0).getRegistrationStatus().equals(RegistrationStatus.APPROVED));
	}
	
	@Test
	public void testCreateRemoveRole() {
		final Role newUserRole = new Role();
		newUserRole.setName(TEST_ROLE_NAME);
		newUserRole.setRecordCreatedBy(TEST_USER_NAME);
		newUserRole.setRecordCreatedDate(TEST_DATE);
		newUserRole.setRecordModifiedBy(TEST_USER_NAME);
		newUserRole.setRecordModifiedDate(TEST_DATE);
		newUserRole.setRecordModifiedCount((short) 1);
		securityDao.persist(newUserRole);
		final Role retrievedRole = securityDao.getRoleByName(TEST_ROLE_NAME);
		assertNotNull(retrievedRole);
		assertEquals(TEST_ROLE_NAME, retrievedRole.getName());
		
		securityDao.remove(retrievedRole);
		assertNull(securityDao.getRoleByName(TEST_ROLE_NAME));
	}
	
	@Test
	public void testFindUsersWithAnyRole() {
		assertEquals(0, securityDao.findUsersWithAnyRole(new ArrayList<String>()).size());
		final List<String> roleList = new ArrayList<String>();
		final String roleName = "Test Role";
		roleList.add(roleName);
		roleList.add("no role");
		roleList.add("");
		final Map<String, UserPrincipal<?>> userMap = securityDao.findUsersWithAnyRole(roleList);
		assertEquals(1, userMap.size());
		assertEquals("testUser", userMap.values().iterator().next().getUsername());
	}
	
	@Test
	public void testFindAppUsers() {
		
		final SearchCriteria sc = new SearchCriteria();
		sc.setLastName("ihtaadmin");
		
		try {
			
			final  List<SimpleUser> users = securityDao.findAppUsers(sc);
			assertTrue(users.size() > 0);
			
		} catch (DAOException e) {
			e.printStackTrace();
		}
		
	}
	
	@Test
	public void testFindAllSimpleROles() throws DAOException{
		// No roles should be System Administrator
		final SimpleRole simpleRole = new SimpleRole();
		simpleRole.setName("System Administrator");
		simpleRole.setId(new Long(2020));
		final List<SimpleRole> roleList = securityDao.findAllSimpleRoles();
		assertTrue(roleList.size() > 0);
		assertFalse(roleList.contains(simpleRole));
	}
	
	@Test
	public void testGetSimpleRoleByName() throws DAOException {
		final String roleName = "Test Role";
		final SimpleRole expectedRole = new SimpleRole();
		expectedRole.setId(new Long(2028));
		expectedRole.setName(roleName);
		final SimpleRole actualRole = securityDao.getSimpleRoleByName(roleName);
		assertEquals(expectedRole.getName(), actualRole.getName());
		assertEquals(expectedRole.getId(), actualRole.getId());
	}
	
	@Test
	public void testGetFederalHolidays() throws DAOException {
		// Most years have 10 holidays, but this isn't guaranteed
		assertEquals(10, securityDao.findHolidays(2012).size());
		// Years only go up to a certain point right now.
		assertEquals(0, securityDao.findHolidays(9999).size());
	}
	
	@Test
	public void testGetUserIds() throws DAOException {
		final List<String> userIds = securityDao.getUserIds();
		assertTrue(userIds.size() > 0);
		assertTrue(userIds.contains("ihtaadmin"));
	}
	
	@Test
	public void testGetAuditUser() throws DAOException {
		final UserPrincipal user = securityDao.getAuditUser(TEST_USER_NAME);
		assertEquals("test", user.getFirstName());
		assertEquals("test", user.getLastName());
	}
	
	@Test
	public void testFindAllPermissions() throws DAOException {
		assertTrue(securityDao.findAllPermissions().size() > 0);
	}
	
	@Test
	public void testDeleteRolePermissionsFromRole() throws DAOException {
		
		Role testRole = new Role();
		Permission testPermission = new Permission();
		
		Set<Permission> permissions = new HashSet<Permission>();
		permissions.addAll(securityDao.findAllPermissions());
		
		testRole.setName(TEST_ROLE_NAME);
		testRole.setRecordCreatedDate(TEST_DATE);
		testRole.setRecordModifiedDate(TEST_DATE);
		testRole.setRecordModifiedBy(TEST_USER_NAME);
		testRole.setRecordCreatedBy(TEST_USER_NAME);
		testRole.setPermissions(permissions, TEST_USER_NAME);

		securityDao.persist(testRole);
		final Role retrievedRole = securityDao.getRoleByName(TEST_ROLE_NAME);
		assertNotNull(testRole);
		
		assertEquals(retrievedRole.getPermissions().size(), permissions.size()); // should have 1 permission
		
		securityDao.deleteRolePermissionsFromRole(testRole);
		
		final Role retrievedRoleAfterDelete = securityDao.getRoleByName(TEST_ROLE_NAME);
		
		assertEquals(retrievedRoleAfterDelete.getPermissions().size(), 0); // should have no permissions
		
		securityDao.deleteEntity(retrievedRoleAfterDelete);
	}
	
	
}
*/