package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.ui.model.TermType;

public class ReportsDAOImplTest {
	static final private String TESTNAME = "Name";
	static final private String TESTNAME2 = "Name2";
	
	@Mock
	private SessionFactory sessionFactory;
	@Mock
	private Session session;
	@Mock
	private NativeQuery<Session> nQuery;
	@Mock
	ReportsDAO reportsDao;

	private List<TermType> result;
	
	@Before
	public void setup() {
		MockitoAnnotations.initMocks(this);
		
		Mockito.doReturn(session).when(sessionFactory).getCurrentSession();
		Mockito.doReturn(nQuery).when(session).createNativeQuery(Mockito.anyString(), Mockito.eq(String.class));
		reportsDao = new ReportsDAOImpl(sessionFactory);
	}
	
	@Test
	public void getModalityTypeWithType0ShouldAddSurvey_DVCTableName() throws DAOException, ParseException {
		String sql = "SELECT NAME "
				+ "FROM ";
			sql += "ht.SURVEY_DVC_MODALITY_TYPE ";
			sql += "WHERE INACTIVE_DATE IS Null";

		assertNotNull(reportsDao.getModalityType(0));
		Mockito.verify(session, Mockito.atLeast(1)).createNativeQuery(sql, String.class);
	}
	
	@Test
	public void getModalityTypeWithType1ShouldAddCensus_DVCTableName() throws DAOException, ParseException {
		String sql = "SELECT NAME "
				+ "FROM ";
			sql += "ht.CENSUS_DVC_MODALITY_TYPE ";
			sql += "WHERE INACTIVE_DATE IS Null";
		assertNotNull(reportsDao.getModalityType(1));
		Mockito.verify(session, Mockito.atLeast(1)).createNativeQuery(sql, String.class);
	}
	
	@Test
	public void getModalityTypeWith2RowsShouldReturn2SuccessfulResults() throws DAOException, ParseException {
		List<String> test = new ArrayList<String>();
		test.add(TESTNAME);
		test.add(TESTNAME2);
		Mockito.doReturn(test).when(nQuery).getResultList();
		result = reportsDao.getModalityType(1);
		assertTrue(result.size() == test.size());
	}
	
	@Test
	public void getModalityTypeWith0RowsShouldReturn0results() throws DAOException, ParseException {
		List<String> test = new ArrayList<String>();
		Mockito.doReturn(test).when(nQuery).getResultList();
		result = reportsDao.getModalityType(1);
		assertTrue(result.size() == test.size());
	}
}
