/*package gov.va.med.ccht.persistent.hibernate;



import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRSearchResult;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.ccht.persistent.QIRDAO;
import gov.va.med.ccht.persistent.VisnDAO;
import gov.va.med.fw.ui.model.TermType;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class QIRDAOImplIntTest {
	
	private final static String UNIT_TEST_NAME = "unit_test";

	private Visn testVisn;
	private QIR testQir;

	TermType testTermType = new TermType(UNIT_TEST_NAME,UNIT_TEST_NAME);

	@Autowired
	private QIRDAO dao;
	
	@Autowired
	private VisnDAO visnDao;
	
	@Autowired
	private SessionFactory sessionFactory;

	protected Session getSession() {
		return this.sessionFactory.getCurrentSession();
	}
	
	@Before
	public void setup() throws Exception{

		testVisn = new Visn();
		testVisn.setName(UNIT_TEST_NAME);
		visnDao.insertVisn(testVisn);
		
		final SimpleVisn simpleVisn = new SimpleVisn();
		simpleVisn.setId(testVisn.getId());
		simpleVisn.setName(testVisn.getName());
		
		testQir = new QIR();
		testQir.setQirStatusType(new QIRStatusType());
		testQir.setSummary(UNIT_TEST_NAME);
		testQir.setVisn(simpleVisn); 
		testQir.setSubmittedByName(UNIT_TEST_NAME);
		dao.saveQIR(testQir);
		
		System.out.println("$$$$$$$$$$$$$$$$$$$$$ qir id = " + testQir.getId());
		
	}
	
	@After
	public void teardown() {
		
//		getSession().delete(testQir);
//		visnDao.deleteVisn(testVisn);
	}
	
	@Test // must test together because QIR ID is auto generated by DB
	public void testSearchQirAndFindById(){
		
		QIRSearchParameters searchParams = new QIRSearchParameters();
		TermType visnTerm = new TermType(UNIT_TEST_NAME, UNIT_TEST_NAME);
		
		searchParams.setSubmittedBy(UNIT_TEST_NAME);
		searchParams.setVisn(visnTerm);
		
		List<QIRSearchResult> results = dao.searchQIR(searchParams);
		
		assertTrue(results.size() > 0);
		
		final QIRSearchResult resultFromDB = results.get(0);
		 
		// test validate searchQir results
		assertEquals(UNIT_TEST_NAME, resultFromDB.getSubmittedByName());
//		assertEquals(UNIT_TEST_NAME, resultFromDB.getVisn());
		
		QIR qirFromDB = dao.findById(testQir.getId());
		
		assertEquals(testQir.getId(), qirFromDB.getId());
		assertEquals(testQir.getSummary(), qirFromDB.getSummary());
		assertEquals(testQir.getSubmittedByName(), qirFromDB.getSubmittedByName());
		assertEquals(testQir.getVisn().getId(), qirFromDB.getVisn().getId());
		
	}
	
	@Test 
	public void testUpdateDeleteFindAttachment() {
		
	}

}*/