/*package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.fw.model.batchprocess.JobConfig;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.model.batchprocess.JobStatus;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class JobDAOImplIntTest {
	
	@Autowired
	private JobDAO dao;
	
	private final static String UNIT_TEST_NAME = "unit_test";
	
	@Before
	public void before() {
		cleanupDatabase();		 
	}
	
	@After
	public void after() {
		cleanupDatabase();
	}
	
	private void cleanupDatabase() {
		
		if (dao.existsJobResultWithName(UNIT_TEST_NAME)) {
			final List<JobResult> jobs = dao.findJobResultsByName(UNIT_TEST_NAME);
			jobs.forEach(job -> {
				dao.deleteJobResult(job);
			});
		}
		
		if (dao.existsJobConfigWithName(UNIT_TEST_NAME)) {
			final List<JobConfig> configs = dao.findJobConfigs(UNIT_TEST_NAME);
			configs.forEach(config -> {
				dao.deleteJobConfig(config);
			});

		}

	}

	@Test
	public void testSaveJobResult() {
		
		JobResult jr = new JobResult();
		jr.setName(UNIT_TEST_NAME);
		jr.setContext(UNIT_TEST_NAME);
		jr.setGroup(UNIT_TEST_NAME);
		jr.setJobStatus(UNIT_TEST_NAME);
		jr.setStatistics(UNIT_TEST_NAME);
		
		dao.saveJobResult(jr);
		
		assertTrue(jr.getId() > 0);
		
	}
	
	@Test
	public void testSaveJobConfig() {

		JobConfig jc = new JobConfig();
		jc.setName(UNIT_TEST_NAME);
		jc.setGroup(UNIT_TEST_NAME);
		
		dao.saveJobConfig(jc);
		
		assertTrue(jc.getId() > 0);

	}
	
	@Test
	public void testFindJobResult() {
		
		JobResult expected = new JobResult();
		expected.setName(UNIT_TEST_NAME);
		
		dao.saveJobResult(expected);
		
		assertTrue(expected.getId() > 0);
		
		JobResult actual = dao.findJobResult(expected.getId());
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}

	@Test
	public void testFindJobConfigByNameAndGroup() {

		JobConfig expected = new JobConfig();
		expected.setName(UNIT_TEST_NAME);
		expected.setGroup(UNIT_TEST_NAME);
		
		dao.saveJobConfig(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobConfig> actuals = dao.findJobConfigs(expected.getName(), expected.getGroup());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobConfig actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		assertEquals(expected.getGroup(), actual.getGroup());
		
	}

	@Test
	public void testFindJobConfigByName() { 

		JobConfig expected = new JobConfig();
		expected.setName(UNIT_TEST_NAME);
		
		dao.saveJobConfig(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobConfig> actuals = dao.findJobConfigs(expected.getName());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobConfig actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}

	@Test
	public void testFindJobResultByName() {

		JobResult expected = new JobResult();
		expected.setName(UNIT_TEST_NAME);
		
		dao.saveJobResult(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobResult> actuals = dao.findJobResultsByName(expected.getName());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobResult actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}
	
	@Test
	public void testFindJobResultByStatus() {

		JobResult expected = new JobResult();
		expected.setName(UNIT_TEST_NAME);
		expected.setJobStatus(UNIT_TEST_NAME);
		
		dao.saveJobResult(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobResult> actuals = dao.findJobResultsByStatus(expected.getJobStatus());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobResult actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}

	@Test
	public void testFindFinishedJobResultsByName() {

		JobResult expected = new JobResult();
		expected.setName(UNIT_TEST_NAME);
		expected.setJobStatus(JobStatus.COMPLETE.getCode());
		
		dao.saveJobResult(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobResult> actuals = dao.findFinishedJobResults(expected.getName());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobResult actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}

	@Test
	public void testFindFinishedJobResultsByNameAndGroup() {

		JobResult expected = new JobResult();
		expected.setName(UNIT_TEST_NAME);
		expected.setGroup(UNIT_TEST_NAME);
		expected.setJobStatus(JobStatus.ERROR.getCode());
		
		dao.saveJobResult(expected);
		
		assertTrue(expected.getId() > 0);

		List<JobResult> actuals = dao.findFinishedJobResults(expected.getName(), expected.getGroup());
		
		assertNotNull(actuals);
		assertEquals(1, actuals.size());
		
		JobResult actual = actuals.get(0);
		
		assertEquals(expected.getId(), actual.getId());
		assertEquals(expected.getName(), actual.getName());
		
	}

}
*/