/*package gov.va.med.ccht.persistent.hibernate;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.med.ccht.model.common.DeviceTrackerLog;
import gov.va.med.ccht.model.common.Facility;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Visn;
import gov.va.med.ccht.persistent.FacilityDAO;
import gov.va.med.ccht.persistent.ReportsDAO;
import gov.va.med.ccht.persistent.VisnDAO;

@ContextConfiguration(locations = "classpath:application-context-test.xml")
@RunWith(SpringJUnit4ClassRunner.class)
public class FacilityDAOImplIntTest {
	  
	@Autowired
	private FacilityDAO facilityDAO;
	
	@Autowired
	private VisnDAO visnDAO;
	
	@Autowired
	private ReportsDAO reportsDAO;
	
	private final static String UNIT_TEST_NAME = "unit_test";
	
	@Before
	public void before() {
		cleanupDatabase();		 
	}
	
	@After
	public void after() {
		cleanupDatabase();
	}
	
	private void cleanupDatabase() {
		
		facilityDAO.getFacilities().forEach(facility -> {
			if (facility.getName().contains(UNIT_TEST_NAME)) {
				facilityDAO.deleteFacility(facility); 
			}
		});
	}
	 
	@Test
	public void testGetFacilities() {
		
		reportsDAO.setVendorComplianceReportCompletion(new ArrayList<DeviceTrackerLog>());
		 
		final List<Facility> facilities = facilityDAO.getFacilities();
		
		assertNotNull(facilities);
		
		final int sizeBeforeUnitTest = facilities.size();
		
		final Facility f = buildTestFacility();
		
		facilityDAO.insertFacility(f);
		
		assertTrue(facilityDAO.getFacilities().size() == sizeBeforeUnitTest + 1);
		assertTrue(facilityDAO.getSimpleFacilities().size() == sizeBeforeUnitTest + 1);
		
		facilityDAO.deleteFacility(f);

		assertTrue(facilityDAO.getFacilities().size() == sizeBeforeUnitTest);

	} 
	
	@Test
	public void testGetFacilitiesByVisnName() {
		
		final Visn visn = new Visn();
		visn.setName(UNIT_TEST_NAME);
		
		visnDAO.insertVisn(visn);
		
		final Facility f = buildTestFacility();
		f.setVisn(visn);
		facilityDAO.insertFacility(f); 
		
		final List<Facility> facilities = facilityDAO.getFacilities(visn.getName());
		assertEquals(1, facilities.size());
		
		SimpleVisn sv = new SimpleVisn();
		sv.setId(visn.getId());
		
		final List<SimpleFacility> simpleFacilities = facilityDAO.getSimpleFacilities(sv);
		assertEquals(1, simpleFacilities.size());
		
		facilityDAO.deleteFacility(f);
		
		visnDAO.deleteVisn(visn);

	}
	
	@Test
	public void testGetSortedSimpleFacilities() {
		
		final Facility f = buildTestFacility();
		
		facilityDAO.insertFacility(f);
		
		final List<SimpleFacility> facilities = facilityDAO.getSortedSimpleFacilities();
		
		assertNotNull(facilities);
		
		facilityDAO.deleteFacility(f);
		
	}
	
	private Facility buildTestFacility() {
		
		final Facility f = new Facility();
		f.setName(UNIT_TEST_NAME);
		f.setStationNumber(UNIT_TEST_NAME);
		return f;
		
	}
	
}
*/