<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/managescheduledjobs.css" />

<script type="text/javascript">
	function printQIR() {
		var selected = $('#selectedQIR').val();
		if (selected != null) {
			window.open('viewQir.html?qirId=' + selected);
		}
	}

	$(function() {
		var table = $('#currentQIRS').DataTable({
			pageLength: 5,
			paging : true,
			autowidth : true,
			searching : false,
			select : 'single',
			order : [ [ 1, "desc" ] ],
            "language" : {
                // Messages used in the case that selections render no data.
                "emptyTable" : '<span tabIndex="0">No data found.</span>'
            }
		})

		$('#currentQIRS tbody').on('click', 'tr', function() {
			var isSelected = $(this).hasClass('selected')
			var data = table.row(this).data()
			$('#selectedQIR').val(isSelected ? data[1] : '')
			refreshButtons()
		})
	})
	function forceFocusOnTableHeader() {

		$(this).parent().focus()	

	}
	
	function refreshButtons() {
		var selectedVal = $('#selectedQIR').val()
		var existingVal = selectedVal != ''
		$('#edit').css("display", existingVal ? "inline-block" : "none")
		if (selectedVal != '') {
			$('#edit')
					.attr(
							'value',
							qirMap[selectedVal].statusCode == "Withdrawn"
									|| qirMap[selectedVal].statusCode == "Closed" ? "View"
									: "Edit")
		}
		$('#pdf').css("display", existingVal ? "inline-block" : "none");
		// $('#excel').css("display", existingVal ? "inline-block" : "none");
	}

	var qirMap = new Object()
	<c:forEach items="${qirList}" var="qir">
	qirMap['${qir.id}'] = {
		statusCode : "<c:out value="${qir.qirStatusType}" />"
	}
	</c:forEach>
</script>

<style>
#edit {
	display: none;
}

#pdf {
	display: none;
}
</style>

<form:form method="get" action="manageQirs.html">
	<input type="hidden" name="fromPage" value="viewMyQirs.html" />
	<form:errors path="*" cssClass="errorBlock" element="div" />

	<table class="stripe dt-head-left dt-body-left hover cell-border"
		id="currentQIRS">
		<thead>
			<tr>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Status">Status</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort TN">TN</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Has Attachment">Has Attachment</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Headline">Headline</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Submitted Date">Submitted Date</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Submitted By">Submitted By</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Facility">Facility</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Vendor">Vendor</a></th>
				<th scope="col"><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Type">Type</a></th>
			</tr>
		</thead>
		<tbody>
			<c:forEach items="${qirList}" var="qir">
				<tr>
					<td tabindex="0"><c:out value="${qir.qirStatusType}" /></td>
					<td tabindex="0"><c:out value="${qir.id}" /></td>
					<c:choose>
						<c:when test="${qir.hasAttachments}">						
							<td tabindex="0" alt="HAS Attachment">
								<img src="images/PaperClip_Black.png" alt="Has Attachment" />
							</td>
						</c:when>
						<c:otherwise>
							<td tabindex="0">
								
							</td>
						</c:otherwise>
					</c:choose>
					<td tabindex="0"><c:out value="${qir.headline}" /></td>
					<td tabindex="0"><c:out value="${qir.submittedDateAsString}" /></td>
					<td tabindex="0"><c:out value="${qir.submittedByName}" /></td>
					<td tabindex="0"><c:out value="${qir.facilityNumAndName}" />
					</td>
					<td tabindex="0"><c:out value="${qir.vendor}" /></td>
					<td tabindex="0"><c:out value="${qir.qirType}" /></td>
				</tr>
			</c:forEach>
		</tbody>
	</table>
	<input type="submit" class="submitAnchor button" id="edit" value="Edit"
		name="editMode" style="display: none" />
	<input type="button" class="submitAnchor button" id="pdf" value="PDF"
		name="PDF" onclick="printQIR()" tabIndex="0" />
	<input type="button" class="submitAnchor button" id="refresh"
		value="Refresh" name="Refresh" tabIndex="0"
		onclick="document.location.href='viewMyQirs.html'" />
	<input type="button" class="submitAnchor button" id="cancel"
		value="Cancel" name="Cancel"
		onclick="javascript:document.location.href='home.html'" tabIndex="0" />
	<input id="selectedQIR" class="submitAnchor" name="selectedQIR"
		type="hidden" value=" " path="selectedQIR" />
</form:form>