<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

    $(function() {
        var vendorStatusTable = $('#vendorStatusTable').DataTable({
            paging : false,
            autowidth : true,
            searching : false,
            ordering : false,
            info : false,
            "language": {
                "emptyTable": '<span tabindex="0">No data found.</span>',
                "infoEmpty" : '<span tabIndex="0">No data found.</span>'
            }
        });
    })
</script>



<div id="vendorStatusContainer">
    <p id="vendorStatusText" tabIndex="0"><b>Note:</b> All Home Telehealth census data is available in the database
    through the week ending ${vendorsReportStatus.lastDayOfReportWeek} except for the following:</p>
    <table id="vendorStatusTable" tabIndex="0" class="stripe dt-head-left dt-body-left hover cell-border">
        <thead>
            <tr>
                <th tabIndex="0">Vendor</th>
                <th tabIndex="0">Last Report Date</th>
            </tr>
        </thead>
        <tbody>
            <c:if test = "${not empty vendorsReportStatus.vendorCensusReportStatus}">
            <c:forEach items="${vendorsReportStatus.vendorCensusReportStatus}" var="status">
                <tr>
                    <td tabIndex="0">${status.vendorName}</td>
                    <td tabIndex="0">
                       <c:choose>
	                       <c:when test = "${not empty status.lastReportDate}">
	                           ${status.lastReportDateAsString}
	                       </c:when>
	                       <c:otherwise>No Report</c:otherwise>
                       </c:choose>
                    </td>
                </tr>
            </c:forEach>
            </c:if>
        </tbody>
    </table>
</div>
