<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
        $(reportTitle).focus();
        
		var nationalTotalsResultsTable = $('#responseRateFacilityResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			columnDefs: [
				{ targets: 0, "width": "200px"},
				{ targets: '_all', "width": "150px" }
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
	})
</script>

<div id="responseRateFacilityResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="responseRateFacilityResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Facility">Facility</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Responders">Responders</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Partial Responders">Partial Responders</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Non-Responders">Non-Responders</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Unknown">Unknown</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="TOTAL">TOTAL</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Non-response for more than 30 days">Non-response for more than 30 days</a></th>
			<th tabIndex="0"><a href="javascript:forceFocusOnTableHeader()" aria-label="Greatest days of non-response">Greatest days of non-response</a></th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${responseRateRows}" var="row">
			<tr>
				<c:choose>
					<%-- There's not really a better way to do this, but the last two rows
					are special cases so you need to match them to this first column value. --%>
					<c:when test="${row.vendorName == 'TOTALS BY RESPONSE RATE'}">
						<td tabIndex="0">${row.vendorName}</td>
						<td tabIndex="0"><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0">TOTAL PTS REPORTED</td>
						<td></td>
						<td></td>
					</c:when>
					<c:when test="${row.vendorName == 'PERCENT OF TOTAL'}">
						<td tabIndex="0">${row.vendorName}</td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnOne}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnTwo}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnThree}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnFour}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.total}" type="number" groupingUsed="true"/></td>
						<td></td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td tabIndex="0">
						<!-- Give the appearance of a link for drilling down into visn and facility. -->
						<form:form method="post" action="responseRateReports.html" commandName="form" class="inline">
							<input type="hidden" name="rrDrillDownFacility" value="true"/>
							<form:hidden path="reportEndDate" value="${reportEndDate}"/>
							<form:hidden path="facilityId" value="${row.stationNumber}"/>
							<form:hidden path="buttonSelection" value="3"/>
							<button type="submit" value="Submit" class="link-button" tabIndex="0">
							Facility ${row.stationNumber} ${row.vendorName}</button>
						</form:form> </td>
						<td tabIndex="0"><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.total}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.thirtyDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.greatestDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<table role="presentation" style="margin-left: auto; margin-right: auto">
     <tr>
         <c:if test="${backButton}">
            <td>
               <%@ include file="censusReportsVisnReturnButton.jsp"%>
            </td>
        </c:if>
        <td>
            <form action="responseRateReports.html">
                <input id="reportsMenuButton" tabindex="0" class="submitAnchor ui-button" type="submit" value="Reports Menu" />
            </form>
        </td>
    </tr>
</table>


<%@ include file="vendorReportStatus.jsp"%>
<%@ include file="responseRateInfo.jsp" %>