<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">
	
	$(function() {
		disableNonUsedInputs();
		$("#vendorId").change(toggleShowVendorSubtotals);
		$("#resetButton").click(resetAllInputs);
		$("input:radio").change(disableNonUsedInputs);
	});
	
    $(document).on("keypress", ":not([type=submit])", function(event) {
        if (event.keyCode == 13) {
            event.preventDefault();
        }
    });
        
	function toggleShowVendorSubtotals() {
		if ($("#vendorId").val() != "-1") {
			$("#showVendorSubtotals").prop("disabled", true)
		}
		else {
			$("#showVendorSubtotals").prop("disabled", false)
		}
	}
	
	function resetAllInputs() {
		$("#nationalButtonSelection").prop("checked", true);
		$("#showVendorSubtotals").prop("checked", false);
		$("#facilityIdText").val("");
		// Reset all dropdowns
		$("select option:first-child").prop("selected", "selected");
	}
	
	function disableNonUsedInputs() {
		if($("input[name=buttonSelection]:checked").val() == "2") {
			$("#visnId").attr("disabled", false);
			$("#facilityIdText").attr("disabled", true);
			$("#facilityIdSelection").attr("disabled", true);
		}
		else if($("input[name=buttonSelection]:checked").val() == "3") {
			$("#visnId").attr("disabled", true);
			$("#facilityIdText").attr("disabled", false);
			$("#facilityIdSelection").attr("disabled", false);
		}
		else {
			$("#visnId").attr("disabled", true);
			$("#facilityIdText").attr("disabled", true);
			$("#facilityIdSelection").attr("disabled", true);
		}
	}
</script>
<div id="censusReportCriteriaContainer">
<form:form method="post" action="reports.html" modelAttribute="form" name="censusActivityReportForm">
	<form:errors path="*" cssClass="error" element="div"/>
	<form:radiobutton id="radio1" path="buttonSelection" value="1" checked="checked" alt="National Totals" tabIndex="0"/>
	<label tabindex="0"><b>National Totals</b></label><br>

	<form:radiobutton id="radio2" path="buttonSelection" value="2" alt="VISN Totals View"  tabIndex="0"/>
	<label tabindex="0"><b>VISN Totals: </b></label>
	<form:select id="visnId" path="visnId" disabled="true" alt="Select VISN" tabindex="0">
		<form:option value="-1" label="All VISNs"/>
		<form:options items="${visns}" itemValue="id" itemLabel="name"/>
	</form:select><br>		
	<form:radiobutton id="radio3" path="buttonSelection" value="3" alt="Facility Totals" tabIndex="0"/>
	<label tabindex="0"><b>Facility Totals:</b></label>
	<label tabindex="0">Enter the Facility ID:</label>
	<form:input id="facilityIdText" maxLength="6" path="facilityId" disabled="true" alt="Enter Facility id"/>
	<label tabindex="0">or select from the list:</label>
	<form:select id="facilityIdSelection" path="facilityId" disabled="true" alt="or select facility id" tabindex="0">
		<form:option value="-1" label="All Facilities"/>
		<form:options items="${facilities}" itemValue="stationNumber" itemLavel="name"/>
	</form:select><br>

	<label tabindex="0">Week Ending: </label>
	<form:select path="reportEndDate"  alt="Week Ending">
		<form:options items="${lastDaysOfWeek}"/>
	</form:select>
	<c:choose >
		<c:when test="${isCategoryOfCareReport}">
		<!-- do not show this attribute only used to determine COC report. -->
		<form:input type="hidden" path="modalityCode" name="drillDownVisn" value="1001" />
		</c:when>
		<c:when test="${isResponseRateReport}">
		<!-- do not show this attribute only used to determine COC report. -->
		<form:input type="hidden" path="modalityCode" name="drillDownVisn" value="1002"/>
		</c:when>
		<c:otherwise>
			<label tabIndex="0">Modality: </label>
			<form:select path="modalityCode" tabindex="0" alt="Modality">
				<form:option value="-1" label="All Modalities"/>
				<form:options items="${modalities}" itemValue="code" itemLabel="description"/>
			</form:select>
		</c:otherwise>
	</c:choose>
	<label tabindex="0">Vendor:</label>
	<c:choose>
	<c:when test="${isResponseRateReport}">
		<form:select path="vendorId" disabled="true" alt="vendor" tabindex="0">
			<form:option value="-1" label="All Vendors"/>
		</form:select>
	</c:when>
	<c:otherwise>
		<form:select path="vendorId" tabindex="0" alt="vendor">
			<form:option value="-1" label="All Vendors"/>
			<form:options items="${vendors}" itemValue="id" itemLabel="name"/>
		</form:select>
	</c:otherwise>
	</c:choose><br>

	<c:choose>
		<c:when test="${isCategoryOfCareReport || isResponseRateReport}">
			<!-- do not show this attribute -->
		</c:when>
		<c:otherwise>
			<form:checkbox id="showVendorSubtotals" path="showVendorSubtotals"/>
			<label tabindex="0">Show Vendor Subtotals </label>
		</c:otherwise>
	</c:choose><br>
	<div id="generateReportContainer">
		<input type="submit" class="submitAnchor ui-button" id="generateReportButton"
			value="Generate Report" name="generateReportButton" tabIndex="0" />
		<input type="button" class="submitAnchor ui-button" id="resetButton"
			value="Reset" tabIndex="0" />
	</div>
</form:form>
</div>
<br><br>
<%@ include file="vendorReportStatus.jsp"%>