<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script src="js/pssReports.js"></script>

<script type="text/javascript">
	
	$(function() {
		$('#allCocCheckbox').change(function() {
			if($(this).is(':checked')) {
				$('#allExceptL2Checkbox').prop('checked', false);
				$('#nicCheckbox').prop('checked', false);
				$('#ccCheckbox').prop('checked', false);
				$('#acmCheckbox').prop('checked', false);
				$('#hpdpCheckbox').prop('checked', false);
				$('#l2Checkbox').prop('checked', false);
			}
		});
		
		$('#allExceptL2Checkbox').change('click', function() {
			if($(this).is(':checked')) {
				$('#allCocCheckbox').prop('checked', false);
				$('#nicCheckbox').prop('checked', false);
				$('#ccCheckbox').prop('checked', false);
				$('#acmCheckbox').prop('checked', false);
				$('#hpdpCheckbox').prop('checked', false);
				$('#l2Checkbox').prop('checked', false);
			}
		});
		
		$('#nicCheckbox, #ccCheckbox, #acmCheckbox, #hpdpCheckbox, #l2Checkbox').change('click', function() {
			if($(this).is(':checked')) {
				$('#allCocCheckbox').prop('checked', false);
				$('#allExceptL2Checkbox').prop('checked', false);
			}
		});
	})
</script>

<div id="waitingDialog" style="display: none;">
    <strong tabindex="0">Generating Report. Please wait...</strong>
</div>

<form:form method="post" action="pssStatisticsReport.html" modelAttribute="pssReportForm">
<form:errors path="*" cssClass="error" element="div"/>
	<table id="pssReportsTable" role="presentation">
		<tr><td colSpan="2"><label tabindex="0">The Patient Level of Satisfaction and the Patient Satisfaction Index
		for a set of Patient Satisfaction surveys will be displayed. 
		To define the set of surveys and the context for the surveys 
		please enter a date range and select National, VISN or facility.</label></td></tr>
		<tr><td colSpan="2" id="graphInstructions"><label tabindex="0">NOTE: In order to see a graph of the Question's 
		Satisfaction percentages, run the report for six months' timeframe or less, then when the report output 
		is generated, click on one of the questions.</label></td></tr>
		<tr>
			<td colSpan="2" class="centerSpan">
				<label tabIndex="0"><b>From: </b></label>
				<form:select path="shortFormatReportFromDate" alt="From Date">
					<form:option value="${fromDate}" />
					<form:options items="${dateByMonths}" />
				</form:select> 
				<label tabIndex="0"><b>To: </b></label>
				<form:select path="shortFormatReportToDate" alt="To Date">
					<form:option value="${toDate}"/>
					<form:options items="${dateByMonths}" />
				</form:select>
			</td>
		</tr>
		<%@ include file="pssBaseReportsMenu.jsp" %>
		<tr>
			<td class="leftColumn" tabindex="0">Select Vendor:</td>
			<td class="rightColumn"><form:select path="vendorId" alt="Select Vendor">
				<form:option value="-1" label="All Vendors"/>
				<form:options items="${vendors}" itemValue="id" itemLabel="name"/>
			</form:select></td>
		</tr>
		<tr>
			<td colSpan="2" class="centerSpan">
				<form:radiobutton path="reportVersionButtonSelection" value="1"  alt="Patient Satisfaction V1.0" tabIndex="0"/><label tabIndex="0">Patient Satisfaction Version 1.0</label>
				<form:radiobutton path="reportVersionButtonSelection" alt="Patient Satisfaction V2.0"
				value="2" tabIndex="0"/><label tabIndex="0">Patient Satisfaction Version 2.0</label>
			</td>
		</tr>
		<tr>
			<td class="centerSpan" colSpan="2" id="graphInstructions"><label tabindex="0" >NOTE: At least one Question Number must be selected</label></td>
		</tr>
		<tr><td class="leftColumn"><label tabindex="0">Include question numbers:</label></td>
			<td class="rightColumn" rowSpan="1"> <c:forEach items="${questions}" var="question">
					<form:checkbox path="questionNumbers" value="${question.choiceNumber}" alt="Include question number ${question.choiceText}"/><label tabIndex="0">${question.choiceText}</label>
				</c:forEach>
			</td>
		</tr>
		<tr>
			<td class="leftColumn"><label tabIndex="0">Category of Care: <br><i>(one must be selected;<br>can select multiples)</i></label>
			</td>
			<td class="rightColumn">
				<form:checkbox id="allCocCheckbox" path="categoriesOfCare" value="-1" alt="Category of Care All"/><label tabIndex="0">All</label><br>
				<form:checkbox id="allExceptL2Checkbox" path="categoriesOfCare" value="-2" alt="Category of Care All Except L2"/><label tabIndex="0">All Except L2</label><br>
				<%-- Hard coding these values, as they should not change. --%>
				<form:checkbox id="nicCheckbox" path="categoriesOfCare" value="1" alt="Category of Care Non-Institutional Care (NIC)"/><label tabIndex="0">Non-Institutional Care (NIC)</label><br>
				<form:checkbox id="ccCheckbox" path="categoriesOfCare" value="2" alt="Category of Care Chronic Care (CC)"/><label tabIndex="0">Chronic Care (CC)</label><br>
				<form:checkbox id="acmCheckbox" path="categoriesOfCare" value="3" alt="Category of Care Acute Care Management (ACM)"/><label tabIndex="0">Acute Care Management (ACM)</label><br>
				<form:checkbox id="hpdpCheckbox" path="categoriesOfCare" value="4" alt="Category of Care Health Promotion/Disease Prevention (HPDP)"/><label tabIndex="0">Health Promotion/Disease Prevention (HPDP)</label><br>
				<form:checkbox id="l2Checkbox" path="categoriesOfCare" value="5" alt="Category of Care Low Acuity/Low Intensity (L2)"/><label tabIndex="0">Low Acuity/Low Intensity (L2)</label><br>
			</td>
		</tr>
	</table>

	<div id="generateReportContainer">
		<input type="submit" class="submitAnchor ui-button" id="generateReportButton"
			value="Generate Report" name="generateReportButton" tabIndex="0" />
	</div>
</form:form>
<%@ include file="pssQuestions.jsp"%>
